package com.digiwin.athena.atmc.common.mongodb.data;

import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import lombok.Data;
import org.apache.tomcat.util.buf.StringUtils;
import org.bson.Document;
import org.springframework.data.mongodb.core.index.Index;

import java.util.ArrayList;
import java.util.List;

/**
 * author:gonghongxing
 * date:2023/6/28
 * description:
 **/
@Data
public class IndexData {

    public IndexData()
    {

    }

    private List<IndexModel> indexList = new ArrayList<>();


    /**
     * 构造索引信息，并返回
     * @param key 索引的key
     * @param sortType 排序类型
     * @return 返回结果
     */
    public List<IndexModel> append(String key,Integer sortType)
    {
        // 该参数为索引的属性配置
        IndexOptions indexOptions = new IndexOptions();
        indexOptions.background(true);
        indexOptions.name(key + "_" + sortType);
        //创建索引
        IndexModel model = new IndexModel(new Document(key,sortType),indexOptions);
        indexList.add(model);
        return indexList;
    }

    /**
     * 获取单个集合的列表
     * @return indexList
     */
    public  List<IndexModel> getSingleIndexes()
    {
        return this.indexList;
    }
}
