package com.digiwin.athena.atmc.common.mongodb.impl;

import com.digiwin.athena.atmc.common.mongodb.MongoDbQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Service
@Slf4j
public class MongoDbQueryServiceImpl implements MongoDbQueryService {

    /**
     * 生成 executeCommand 查询对象
     * @param collectionName collection名称
     * @param filterMap 查询条件
     * @return
     */
    @Override
    public Map getExecuteQueryCommand(String collectionName, Map filterMap) {
        return getExecuteQueryCommand(collectionName, filterMap, null);
    }

    /**
     * 生成 executeCommand 查询对象
     * <br>参考：https://www.mongodb.com/docs/manual/reference/command/find/#mongodb-dbcommand-dbcmd.find
     * @param collectionName collection名称
     * @param filterMap 查询条件
     * @param projectionMap 返回属性
     * @return
     */
    @Override
    public Map getExecuteQueryCommand(String collectionName, Map filterMap, Map projectionMap) {
        Map command = new LinkedHashMap();
        command.put("find", collectionName);

        if(filterMap!=null && !filterMap.isEmpty()) {
            command.put("filter", filterMap);
        }

        if(projectionMap!=null && !projectionMap.isEmpty()) {
            command.put("projection", projectionMap);
        }

        command.put("batchSize", 10000);
        command.put("singleBatch", true);
        return command;
    }

    /**
     * 将map的Key平铺，并加上指定的前缀。
     * <p>不处理含list的value</p>
     * @param prefix
     * @param oldMap 旧的map
     * @return 平铺后的map
     */
    @Override
    public Map tileMap(String prefix, Map oldMap) {
        Map newMap = new HashMap();
        tileMap(prefix, oldMap, newMap);
        return newMap;
    }

    /**
     * 将map的Key平铺，并加上指定的前缀
     * @param prefix
     * @param oldMap 旧的map
     * @param newMap 新的map
     */
    private void tileMap(String prefix, Map oldMap, Map newMap){
        for (Object o : oldMap.keySet()) {
            if(oldMap.get(o) instanceof Map){
                tileMap(prefix+"."+o.toString(),(Map)oldMap.get(o),newMap);
            }else {
                newMap.put(prefix + "." + o.toString(), oldMap.get(o));
            }
        }
    }

}
