package com.digiwin.athena.atmc.common.processor;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @Author wuzq
 * @Date 2023/5/25 13:26
 * @Description: 注入国际化配置
 * @Version 1.0
 */
@Component
public class CommonMessageSourceBeanPostProcessor implements BeanPostProcessor {

    private static final String messagesBasename = "i18n/common-messages";

    /**
     * 对初始化之前的Bean进行处理
     *
     * @param obj      即将初始化的 Bean
     * @param beanName Bean 的名称
     * @return 返回给用户的那个 Bean ,可以修改 Bean 也可以返回一个新的bean
     * @throws BeansException
     */
    @Override
    public Object postProcessBeforeInitialization(Object obj, String beanName) throws BeansException {
        if (obj instanceof ResourceBundleMessageSource) {
            ResourceBundleMessageSource messageSource = (ResourceBundleMessageSource) obj;
            Set<String> basenameSet = messageSource.getBasenameSet();
            basenameSet.add(messagesBasename);
            messageSource.setBasenames(basenameSet.toArray(new String[0]));
        }
        return obj;
    }

    /**
     * 对初始化之后的Bean进行处理
     *
     * @param obj      即将初始化的 Bean
     * @param beanName Bean 的名称
     * @return 返回给用户的那个 Bean ,可以修改 Bean 也可以返回一个新的bean
     * @throws BeansException
     */
    @Override
    public Object postProcessAfterInitialization(Object obj, String beanName) throws BeansException {
        return obj;
    }
}