package com.digiwin.athena.atmc.common.service.backlog;

import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;

import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service
public class BacklogActionCreateParentService {
    @Autowired
    private ThemeMapService themeMapService;

    /**
     * 处理查看签核历程，例如在 采购发起 中显示 签核历程
     *
     * @param workitemId
     * @param backLogMap
     * @param map
     */
    public void processApproval(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        //如果是非签核类型，不需要处理查看签核历程
        if (Objects.equals(backLogMap.getTmCategory(), TmTaskCategoryEnum.SOLVE.getValue())) {
            //排除异常排除类型的，因为异常排除的签核历程在每一行中
            return;
        }
        String tmTaskId = backLogMap.getTmTaskId();
        String tmActivityId = backLogMap.getTmActivityId();
        String targetApproveActivity = getTargetApproveActivity(tmTaskId, tmActivityId);
//        targetApproveActivity = "A20231102164144_AthenaQCPaasW_task_0003";
        if (org.apache.commons.lang.StringUtils.isBlank(targetApproveActivity)) {
            return;
        }
        List tasks = (List) map.get("tasks");
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        for (Object taskObj : tasks) {
            Map task = (Map) taskObj;
            List<Map> backlogs = (List<Map>) task.get("backlog");
            Map backlog = backlogs.get(0);

            Object workItemId = (backlog.containsKey("ptmBacklogId") && null != backlog.get("ptmBacklogId")) ?
                    backlog.get("ptmBacklogId") : backlog.get("backlogId");

            Map<String, Object> signProgressMap = new HashMap<>();
            signProgressMap.put("processSerialNumber", task.get("processSerialNumber"));
            List<String> activityIds = new ArrayList<>();
            activityIds.add(targetApproveActivity);
            signProgressMap.put("tmActivityIds", activityIds);
            signProgressMap.put("workitemId", workItemId);
            signProgressMap.put("ptmWorkItemId", backlog.get("ptmWorkItemId"));

            task.put("relationApproval", signProgressMap);
        }
    }

    private String getTargetApproveActivity(String tmTaskId, String tmActivityId) {

        return themeMapService.getActivityTargetCode(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
    }
}
