package com.digiwin.athena.atmc.common.service.bpmworkitemappendix;

import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.domain.backlog.ReplyTaskMessageDTO;
import com.digiwin.athena.atmc.common.domain.BpmWorkitemAppendix;

import java.util.List;
import java.util.Map;


/**
 * workitem附加信息服务
 */
public interface BpmWorkitemAppendixService {

    /**
     * 回复型任务 - 流程引擎，增加待办的附加信息
     * @param workitemAppendixType
     * @param workItemId
     * @param email
     * @param supplierName
     * @return
     */
    BpmWorkitemAppendix addReplyTaskByBpmWorkItemId(WorkitemAppendixType workitemAppendixType, Long workItemId, String email, String supplierName);

    /**
     * 回复型任务 - PTM，增加待办的附加信息
     * @param workitemAppendixType
     * @param ptmBacklogId
     * @param contact
     * @param supplierName
     * @return
     */
    BpmWorkitemAppendix addReplyTaskByPtmBacklogId(WorkitemAppendixType workitemAppendixType, Long ptmBacklogId, String contact, String supplierName);

    /**
     * 回复型任务- 根据backlogId查找对应的 附加信息
     * @param backlogId
     * @return
     */
    BpmWorkitemAppendix getByBacklogId(Long backlogId);
    /**
     * 回复型任务- 根据ptmBacklogId查找对应的 附加信息
     * @param backlogId
     * @return
     */
    BpmWorkitemAppendix getByPtmBacklogId(Long backlogId);

    /**
     * 获取 回复型 任务的错误信息
     * @param backlogId
     * @return
     */
    ReplyTaskMessageDTO getReplyTaskMessage(Long backlogId);

    /**
     * 批量获取附加信息根据id
     */
    List<BpmWorkitemAppendix> getByBacklogIdBatch(List<Long> backlogIds);

    /**
     * 批量获取任务卡追加信息
     * @param cardIds
     * @return
     */
    Map<Long,String> getTaskCardAppendixMessage(List<Long> cardIds);
}
