package com.digiwin.athena.atmc.common.service.workflow;

import com.digiwin.athena.atmc.common.constant.TaskConstant;
import com.digiwin.athena.atmc.common.domain.WorkflowInstance;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalStepDTO;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalWorkItemDTO;
import com.digiwin.athena.atmc.common.enums.ActivityWorkitemSubState;
import com.digiwin.athena.atmc.common.enums.SignCategory;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowProcess;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowWorkItem;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@Slf4j
public class WorkflowTransformService {

    @Autowired
    private WorkflowService workflowService;

    @Autowired
    private UserService userService;

    /**
     *  获取用户名称
     * @param nameMap
     * @param userId
     * @return
     */
    private String getUserName(Map<String,String> nameMap,String userId){
        if(StringUtils.isNotBlank(userId)){
            if(nameMap.containsKey(userId)){
                return nameMap.get(userId);
            }
            UserDTO userDTO = userService.query(userId);
            String userName = null;
            if(userDTO != null){
                userName = userDTO.getName();
            }
            nameMap.put(userId,userName);
            return userName;
        }
        return null;

    }

    private ApprovalStepDTO builderSignInformer(WorkflowProcess signProcess, JSONObject informer, String noticeType){
        if(signProcess==null || informer==null){
            return null;
        }
        if(informer.containsKey(noticeType)){
            JSONArray noticeArray = JSONArray.fromObject(informer.get(noticeType));
            if(noticeArray==null || noticeArray.isEmpty()){
                return null;
            }
            ApprovalStepDTO step = ApprovalStepDTO.builder()
                    .id(0L)
                    .bpmActivityId(signProcess.getActivityId())
                    .bpmActivityName(signProcess.getActivityName())
                    .state(TaskConstant.ACTIVITY_COMPLETED)
                    .isReassign(false)
                    .isReexecute(false)
                    .build();
            List<ApprovalWorkItemDTO> workItemList = new ArrayList<>();
            for (Object sn : noticeArray) {
                JSONObject noticeObject= JSONObject.fromObject(sn);
                if (!noticeObject.containsKey("userId")  || StringUtils.isBlank(noticeObject.getString("userId"))) {
                    continue;
                }

                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder()
                        .performerId(noticeObject.getString("userId"))
                        .build();
                if (noticeObject.containsKey("userName")  && StringUtils.isNotBlank(noticeObject.getString("userName"))) {
                    workItem.setPerformerName(noticeObject.getString("userName"));
                }
                if (noticeObject.containsKey("sendTime")  && StringUtils.isNotBlank(noticeObject.getString("sendTime"))) {
                    workItem.setClosedTime(null);
                }
                workItemList.add(workItem);
            }
            step.setWorkitemList(workItemList);
            return step;
        }


        return null;
    }

    /**
     * 获取工作流历史轨迹，透传
     * @param workflowInstance
     * @return
     */
   public  Map<String,Object>  getWorkflowHistory(WorkflowInstance workflowInstance){
        return workflowService.getWorkflowProcess(workflowInstance.getSerialNumber(), workflowInstance.getWorkItemId());
    }

}
