package com.digiwin.athena.atmc.common.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.domain.CardActivityDto;
import com.digiwin.athena.atmc.common.domain.CardInfoDto;
import com.digiwin.athena.atmc.common.domain.CardItemDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;
@Slf4j
public class CommonUtils {
    public final static String SUMMARY_LAYOUT = "summaryLayout";
    public final static String HISTORY_MESSAGE = "historyMessage";
    public final static String SEARCH_MESSAGE = "searchMessage";

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return  null;
        }
        int totalSize = datas.size();
        int count = (totalSize % splitSize == 0) ?
                (totalSize / splitSize) : (totalSize/splitSize+1);
        List<List<T>> rows = new ArrayList<>(splitSize);
        for (int i = 0; i < count;i++) {
            List<T> cols = datas.subList(i * splitSize,
                    (i == count - 1) ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto){
        return getActivityMessageStr(cardInfoDto,Maps.newHashMap());
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto,Map<Long,Map<String,Set<String>>> activityMsg){
        List<CardItemDto> cardItemList = cardInfoDto.getCardItemList();
        if(CollectionUtils.isEmpty(cardItemList) || activityMsg == null){
            return null;
        }
        for (CardItemDto cardItemDto : cardItemList) {
            Long activityId = cardItemDto.getActivityId();
            if(activityId == null){
                continue;
            }
            Map<String, Set<String>> map = activityMsg.computeIfAbsent(cardItemDto.getActivityId(), e -> new HashMap<>());
            Map<String, Object> cardInfo = cardItemDto.getCardInfo();
            addCardText(map,cardInfo,SUMMARY_LAYOUT);
            addCardText(map,cardInfo,HISTORY_MESSAGE);
            addCardText(map,cardInfo,SEARCH_MESSAGE);
        }
        CardActivityDto cardActivityDto = new CardActivityDto();
        cardActivityDto.setActivityMsg(activityMsg);
        return JsonUtils.objectToString(cardActivityDto);
    }


    public static String getActivityMessageStr(Long activityId,Map<String,Object> cardData){
        if(activityId != null && cardData !=null){
            CardInfoDto cardInfoDto = new CardInfoDto();
            cardInfoDto.setCardItemList(Lists.newArrayList(new CardItemDto(activityId,cardData)));
            return getActivityMessageStr(cardInfoDto);
        }
        return null;
    }




    public static Map<String,Object> getCardMap(String summary,String history,String search){
        Map<String,Object> map = Maps.newHashMapWithExpectedSize(3);
        map.put(SUMMARY_LAYOUT,summary);
        map.put(HISTORY_MESSAGE,history);
        map.put(SEARCH_MESSAGE,search);
        return map;
    }


    public static String getActivityMessageStr(String activityMessage,Long activityId,Map<String,Object> cardData){
        if(activityId == null || cardData ==null){
            return activityMessage;
        }
        CardActivityDto cardActivity = getCardActivity(activityMessage);
        CardInfoDto cardInfoDto = new CardInfoDto();
        cardInfoDto.setCardItemList(Lists.newArrayList(new CardItemDto(activityId,cardData)));
        if(cardActivity == null){
            return getActivityMessageStr(cardInfoDto);
        }else {
            return getActivityMessageStr(cardInfoDto,cardActivity.getActivityMsg());
        }
    }

    public static CardActivityDto getCardActivity(String activityMessage){
        if(StringUtils.isNotEmpty(activityMessage)){
            try {
                return JsonUtils.jsonToObject(activityMessage,CardActivityDto.class);
            }catch (Exception e){
                log.warn("转换活动级摘要信息错误:{},原:{}",e.getMessage(),activityMessage);
            }
        }
        return null;
    }

    public static Map<String, Set<String>> getCardInfoMap(String activityMessage,Long activityId){
        if(activityId != null){
            CardActivityDto cardActivity = getCardActivity(activityMessage);
            if(cardActivity != null){
                Map<Long, Map<String, Set<String>>> activityMsg = cardActivity.getActivityMsg();
                if(activityMsg != null){
                    return activityMsg.getOrDefault(activityId,Collections.emptyMap());
                }
            }
        }
        return null;
    }



    private static void addCardText(Map<String, Set<String>> map,Map<String, Object> cardInfo,String key){
        Set<String> textList = map.computeIfAbsent(key, e -> new HashSet<>());
        String summaryText = MapUtils.getString(cardInfo, key);
        if(StringUtils.isNotBlank(summaryText)){
            String[] split = summaryText.split("<br>");
            for (String s : split) {
                String[] rowSplit = s.split("：");
                String[] dataSplit;
                if(rowSplit.length>1){
                    dataSplit = rowSplit[1].split(",");
                    textList.add(rowSplit[0]);
                }else{
                    dataSplit = rowSplit[0].split(",");
                }
                textList.addAll(Arrays.asList(dataSplit));
            }
        }

    }


    public static void main(String[] args) {
//        CardActivityDto cardActivityDto = new CardActivityDto();
//        Map<Long, Map<String, Set<String>>> map = new HashMap<>();
//        map.put(null,new HashMap<>());
//        cardActivityDto.setActivityMsg(map);
//        System.out.println(JsonUtils.objectToString(cardActivityDto));;

        String activityMessageStr = CommonUtils.getActivityMessageStr(484371628597376L, getCardMap("用户123：202409191253281,202409191253282 N<br>用户名22：张浩晨,常润莎<br>状态22：N", "", "用户：202409191253281,202409191253282"));
        System.out.println(activityMessageStr);
    }
}
