package com.digiwin.athena.atmc.common.util.engine;

import com.digiwin.athena.atmc.common.domain.engine.SplitEngine;
import com.digiwin.athena.atmc.common.enums.FlowEngineTableEnum;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;


import java.util.*;

import static com.digiwin.athena.atmc.common.util.engine.FlowEngineDataRedisUtils.getFlowEngineIdFromRedis;
import static com.digiwin.athena.atmc.common.util.engine.FlowEngineDataRedisUtils.insertFlowEngineIdToRedis;

/**
 * @description:
 * @author: xusj
 * @date: 2023/7/31 16:09
 */
public class AnalysisEngineKeyUtils {
    /**
     * 根据引擎类型拆分id
     */
    public static SplitEngine splitActivityId(List<Long> ids, FlowEngineTableEnum tableName) {
        SplitEngine splitEngine = new SplitEngine();
        if (CollectionUtils.isEmpty(ids)) {
            return splitEngine;
        }
        // 流程引擎id
        List<Long> flowEngineIds = new ArrayList<>();
        //用缓存先过滤
        ids.forEach(t -> {
            if (getFlowEngineIdFromRedis(t)) {
                flowEngineIds.add(t);
            }
        });
        ids.removeAll(flowEngineIds);

        // 根据表名获取流程引擎的id  继续查询表过滤
        if (CollectionUtils.isNotEmpty(ids)) {
            getBpmActivityWorkitemIds(tableName, ids, flowEngineIds);
            getBacklogIds(tableName, ids, flowEngineIds);
            getBpmActivityIds(tableName, ids, flowEngineIds);
            getBpmActivityStepIds(tableName, ids, flowEngineIds);
            getActivityIds(tableName, ids, flowEngineIds);
            getTaskIds(tableName, ids, flowEngineIds);
            getBpmProcessIds(tableName, ids, flowEngineIds);
        }
        //缓存流程引擎id
        flowEngineIds.forEach(id -> insertFlowEngineIdToRedis(tableName.getValue(), id));

        // 保留ptm的id
        ids.removeAll(flowEngineIds);
        //结果
        // PS：需要定义成对象
        splitEngine.setFlowEngineIds(flowEngineIds);
        splitEngine.setPtmIds(ids);
        return splitEngine;
    }

    /**
     * 从提交的action中解析出任务id
     * @param submitAction
     * @return
     */
    public static Long getActivityIdFromAction(SubmitActionDTO submitAction) {
        Long backlogId = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            backlogId = submitAction.getAction().getExecuteContext().getAbnormalWorkitemId();
        }
        return backlogId;
    }

    /**
     * 从提交的action中解析出流程序号
     * @param submitAction
     * @return
     */
    public static String getProcessNumberFromAction(SubmitActionDTO submitAction) {
        String processSerialNumber = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            processSerialNumber = submitAction.getAction().getExecuteContext().getProcessSerialNumber();
        }
        return processSerialNumber;
    }

    /**
     * 从提交的action中解析出projectCode
     * @param submitAction
     * @return
     */
    public static String getProjectCodeFromAction(SubmitActionDTO submitAction) {
        String projectCode = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            projectCode = submitAction.getAction().getExecuteContext().getTmProjectId();
        }
        return projectCode;
    }


    /**
     * 从报表信息中解析出任务id
     * @param rowDataMap
     * @return
     */
    public static Long getActivityIdFromRowData(Map<String,Object> rowDataMap) {
        Long workitemId = null;
        if(rowDataMap != null && rowDataMap.containsKey("activity__backLog__data") && null != rowDataMap.get("activity__backLog__data")) {
            Map backlogMap = (Map) rowDataMap.get("activity__backLog__data");
            workitemId = Long.valueOf(backlogMap.get("backlogId").toString());
            if(backlogMap.containsKey("ptmBacklogId") && null != backlogMap.get("ptmBacklogId")){
                workitemId = Long.valueOf(backlogMap.get("ptmBacklogId").toString());
            }
        }
        return workitemId;
    }

    /**
     * 从map中解析出任务id
     * @param map
     * @param key
     * @return
     */
    public static Long getActivityIdFromMap(Map map, String key) {
        if (MapUtils.isEmpty(map)) {
            return 0L;
        }
        if (!map.containsKey(key)) {
            return 0L;
        }
        return MapUtils.getLong(map, key, 0L);
    }



    private static void getBpmActivityWorkitemIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivityWorkitem.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityWorkitemMapper().queryByIds(originalIds));
    }

    private static void getBacklogIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.backlog.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBacklogMapper().queryByIds(originalIds));
    }

    private static void getBpmActivityStepIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivityStep.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityStepMapper().queryByIds(originalIds));
    }

    private static void getBpmActivityIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivity.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityMapper().queryByIds(originalIds));
    }

    private static void getActivityIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.activity.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getActivityMapper().queryByIds(originalIds));
    }

    private static void getTaskIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.task.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getTaskMapper().queryByIds(originalIds));
    }

    private static void getBpmProcessIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmProcess.equals(tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmProcessMapper().queryByIds(originalIds));
    }
}

