package com.digiwin.athena.atmc.common.util.engine;

import com.digiwin.athena.appcore.util.SpringUtil;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 流程引擎数据缓存
 */
public class FlowEngineDataRedisUtils {
    // redis前缀
    private static final String redisKeyPreFix = "atmc:cache:flow:engine:";
    private static StringRedisTemplate stringRedisTemplate;

    public static StringRedisTemplate getStringRedisTemplate() {
        if (Objects.isNull(stringRedisTemplate)) {
            synchronized (FlowEngineDataRedisUtils.class) {
                if (Objects.isNull(stringRedisTemplate)) {
                    stringRedisTemplate = SpringUtil.getBean(StringRedisTemplate.class);
                }
            }
        }
        return stringRedisTemplate;
    }

    /**
     * 存缓存
     */
    public static void insertFlowEngineIdToRedis(String tableName, Long id) {
        getStringRedisTemplate().opsForValue().setIfAbsent(redisKeyPreFix + id, tableName, 15, TimeUnit.MINUTES);
    }

    /**
     * 判断缓存是否存在
     */
    public static Boolean getFlowEngineIdFromRedis(Long id) {
        return getStringRedisTemplate().hasKey(redisKeyPreFix + id);
    }
}
