/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.dap.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.dap.DapService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DapServiceImpl
implements DapService {
    private static final Logger logger = LoggerFactory.getLogger(DapServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public boolean createAuthorization(String customTenantId, String appId, String token) {
        Map dataMap;
        String data;
        Object response;
        boolean result = false;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("partnerTenantid", customTenantId);
        HttpEntity validHttpEntity = new HttpEntity((MultiValueMap)headers);
        String validUrl = this.envProperties.getTdscUri() + "/restful/service/tdsc/PartnerRelationship/Valid?partnerTenantid={partnerTenantid}";
        ResponseEntity validResponse = this.restTemplate.exchange(validUrl, HttpMethod.GET, validHttpEntity, Map.class, paramMap);
        if (validResponse.getStatusCode() == HttpStatus.OK && (response = ((Map)validResponse.getBody()).get("response")) != null && response != "" && "true".equalsIgnoreCase(data = (String)(dataMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), Map.class)).get("data"))) {
            return true;
        }
        ArrayList<String> tenantIdList = new ArrayList<String>();
        tenantIdList.add(customTenantId);
        ArrayList<HashedMap> authorizationsList = new ArrayList<HashedMap>();
        HashedMap authorizationsMap = new HashedMap();
        authorizationsMap.put("dataProviderAppId", appId);
        authorizationsMap.put("dataProviderResourceName", "/api/atmc/v1/activity/changed");
        authorizationsMap.put("authDateStart", LocalDate.now());
        authorizationsMap.put("authDateEnd", "9999-12-31");
        authorizationsList.add(authorizationsMap);
        paramMap.clear();
        paramMap.put("partnerTenantids", tenantIdList);
        paramMap.put("authGroup", "multiTenant");
        paramMap.put("authorizations", authorizationsList);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        String url = this.envProperties.getTdscUri() + "/restful/service/tdsc/Authorization/valid";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        responseEntity.getStatusCode();
        if (responseEntity.getStatusCode() == HttpStatus.OK) {
            result = true;
        }
        return result;
    }
}

