/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.dap.impl;

import com.digiwin.athena.atmc.http.domain.eventlog.EventLogDTO;
import com.digiwin.athena.atmc.http.domain.task.SearchReqDTO;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.dap.EventLogService;
import com.digiwin.athena.atmc.http.util.AppTimeUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EventLogServiceImpl
implements EventLogService {
    private static final Logger log = LoggerFactory.getLogger(EventLogServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public void addEventLog(EventLogDTO dto) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject req = new JSONObject();
        JSONObject params = new JSONObject();
        params.put((Object)"database", (Object)"event_log");
        params.put((Object)"table", (Object)"athena_atmc_event_log");
        JSONArray datas = new JSONArray();
        datas.add((Object)dto);
        params.put((Object)"datas", (Object)datas);
        req.put((Object)"params", (Object)params);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = this.envProperties.getDapUri() + "/restful/service/DWEvent/IEventService/postByCondition";
        this.restTemplate.postForObject(url, (Object)httpEntity, String.class, new Object[0]);
    }

    @Override
    public JSONObject getEventLog(SearchReqDTO reqDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject req = new JSONObject();
        JSONObject queryInfo = new JSONObject();
        queryInfo.put((Object)"pageSize", (Object)reqDTO.getPageSize());
        queryInfo.put((Object)"pageNumber", (Object)reqDTO.getPageNumber());
        JSONObject condition = new JSONObject();
        condition.put((Object)"database", (Object)"event_log");
        condition.put((Object)"table", (Object)"athena_atmc_event_log");
        condition.put((Object)"searchColumns", (Object)"createTime,eventContent");
        condition.put((Object)"searchText", (Object)reqDTO.getParam());
        condition.put((Object)"tenantId", (Object)reqDTO.getTenantId());
        queryInfo.put((Object)"condition", (Object)condition);
        JSONObject order = new JSONObject();
        order.put((Object)"createTime", (Object)"desc");
        queryInfo.put((Object)"order", (Object)order);
        req.put((Object)"queryInfo", (Object)queryInfo);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = this.envProperties.getDapUri() + "/restful/service/DWEvent/IEventService/getByCondition";
        JSONObject response = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject result = new JSONObject();
        result.put((Object)"code", (Object)0);
        result.put((Object)"message", (Object)"ok");
        result.put((Object)"total", (Object)response.getJSONObject("response").getString("count"));
        JSONArray resultDataList = this.convert(response.getJSONObject("response").getJSONArray("datas"));
        result.put((Object)"data", (Object)resultDataList);
        return result;
    }

    private JSONArray convert(JSONArray jsonArray) {
        if (null == jsonArray || jsonArray.isEmpty()) {
            return jsonArray;
        }
        for (int idx = 0; idx < jsonArray.size(); ++idx) {
            JSONObject jsonObj = jsonArray.getJSONObject(idx);
            if (null == jsonObj || !this.needConvertCreateTime(jsonObj)) continue;
            jsonObj.put((Object)"createTime", (Object)AppTimeUtil.utcZone0ToLocal(jsonObj.getString("createTime"), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss"));
        }
        return jsonArray;
    }

    private boolean needConvertCreateTime(JSONObject doc) {
        if (doc.containsKey((Object)"createTime") && StringUtils.isNotBlank((String)doc.getString("createTime"))) {
            String createTime = doc.getString("createTime");
            return StringUtils.contains((String)createTime, (String)"T");
        }
        return false;
    }
}

