/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.tenant.TenantBaseRespDto;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.TenantService;
import com.digiwin.athena.atmc.http.restful.iam.model.IamTenantSimpleDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TenantServiceImpl
implements TenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public boolean isTest(String token, String id) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", token);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/simple";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        Map result = (Map)responseEntity.getBody();
        if (null == result || !result.containsKey("testTenant")) {
            return false;
        }
        return (Boolean)result.get("testTenant");
    }

    @Override
    public List<TenantBaseRespDto> queryTenant(String content, String taxNo, AuthoredUser user) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", user.getToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + AtmcStrUtil.format("/api/iam/v2/tenant/relevantinfo?tenantContent={content}&unifiedTaxationCode={taxNo}", content, taxNo);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONArray.class, new Object[0]);
        if (null == responseEntity.getBody()) {
            return new ArrayList<TenantBaseRespDto>();
        }
        JSONArray arrs = (JSONArray)responseEntity.getBody();
        return (List)JSONArray.toCollection((JSONArray)arrs, TenantBaseRespDto.class);
    }

    @Override
    public IamTenantSimpleDTO getTenantSimple(String tenantId) {
        String uri = this.envProperties.getIamUri() + "/api/iam/v2/tenant/simples";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ArrayList<String> param = new ArrayList<String>();
        param.add(tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<IamTenantSimpleDTO>>(){}, new HashMap());
        List resultList = (List)responseEntity.getBody();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            return (IamTenantSimpleDTO)resultList.get(0);
        }
        return null;
    }

    @Override
    public JSONObject queryApiVirtualToken(String tenantId) {
        String uri = this.envProperties.getIamUri() + "/api/iam/v2/identity/login/internal";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<JSONObject>(){}, param);
        JSONObject result = (JSONObject)responseEntity.getBody();
        if (null == result) {
            log.error("this tenant :{}return none virtual token.", (Object)tenantId);
            return new JSONObject();
        }
        return result;
    }
}

