/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.thememap.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.search.SearchDto;
import com.digiwin.athena.atmc.http.domain.search.SearchPojo;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.BusinessKeyDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivitiesResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppExpireChangeComponentDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmApplicationDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAssignConfigDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmDataState;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmReportDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmSolvePlanActivityDataDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskDefineResponseDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ThemeMapServiceImpl
implements ThemeMapService {
    private static final Logger log = LoggerFactory.getLogger(ThemeMapServiceImpl.class);
    private static final int NOT_NEED_SEARCH = -999;
    private static final String APPLY_PROJECT_TYPE_STR = "2";
    private static final String APPLY_ENTRY_TYPE_STR = "3";
    private static final String APPLY_REPORT_TYPE_STR = "4";
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public TmTaskDefineResponseDTO getTask(String taskId) {
        TmTaskDefineResponseDTO result = null;
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/definitionWithMultiLanguage?taskId={taskId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmTaskDefineResponseDTO>>(){}, param);
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        result = (TmTaskDefineResponseDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
        if (result != null) {
            if (result.getMerge() == null) {
                result.setMerge(true);
            }
            if (result.getAssignAble() == null) {
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(result.getAssignAble()).assignTo(result.getAssignTo()).build();
                result.setAssignConfig(assignConfig);
            }
        }
        return result;
    }

    @Override
    public TmActivitiesResponseDTO getActivities(String taskId, String compositionId) {
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activitiesWithMultiLanguage?taskId={taskId}&compositionId={compositionId}";
        if (org.springframework.util.StringUtils.isEmpty((Object)compositionId)) {
            uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activitiesWithMultiLanguage?taskId={taskId}";
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        param.put("compositionId", compositionId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmActivitiesResponseDTO>>(){}, param);
            return (TmActivitiesResponseDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {
        TmActivityResponseDTO result = null;
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activityDefinition?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        if ("__uibot__".equals(tmTaskId)) {
            uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activityDefinition?activityId={activityId}&pageCode={pageCode}";
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>(){}, param);
            result = (TmActivityResponseDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        if (result != null) {
            if (result.getPages() != null && CollectionUtils.isNotEmpty(result.getPages().getDataStates()) && result.getPages().getDataStates().size() > 0) {
                TmDataState dataState = result.getPages().getDataStates().get(0);
                result.getPages().setCardCache(dataState.getCardCache());
            }
            if (result.getPages() != null && result.getPages().getCardCache() == null) {
                result.getPages().setCardCache(true);
            }
            if (result.getAssignAble() == null) {
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(result.getAssignAble()).assignTo(result.getAssignTo()).build();
                result.setAssignConfig(assignConfig);
            }
        } else {
            throw BusinessException.create((String)ErrorCodeEnum.KM_RTN_NULL.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.tm.null"), uri));
        }
        return result;
    }

    @Override
    public Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode) {
        Map result = null;
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activityDefinition?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
            result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public Map executeFormula(String formulaId) {
        Map result = null;
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/tenantSettings/formula?formulaId={formulaId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formulaId", formulaId);
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
            result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public TmSolvePlanActivityDataDTO getSolvePlanActivities(String dataName, String planId) {
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/activity/queryCompositionBySolvePlan";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dataName", dataName);
        param.put("planId", planId);
        try {
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmSolvePlanActivityDataDTO>>(){}, new HashMap());
            return (TmSolvePlanActivityDataDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    private Map getResponse(Map responseMap) {
        if (responseMap != null && responseMap.containsKey("response") && responseMap.get("response") instanceof Map) {
            return (Map)responseMap.get("response");
        }
        return null;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    @Override
    public List<TmReportDTO> getReportSummaryList(String bizCode, Integer type) {
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/reportsByBizCodeNType")).queryParam("bizCode", new Object[]{bizCode}).queryParam("type", new Object[]{type}).build().toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", this.getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmReportDTO>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("[ThemeMapServiceImpl.getReportSummaryList] get report summary list failed");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public List<TmReportDTO> getReportRelativeActivities(String reportCode, Integer type) {
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/bizsByReportCodeNType")).queryParam("reportCode", new Object[]{reportCode}).queryParam("type", new Object[]{type}).build().toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", this.getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmReportDTO>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public TmReportDTO getReportDetail(String bizCode, Integer type, String reportCode) {
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/reportByBizCodeNTypeNReportCode")).queryParam("bizCode", new Object[]{bizCode}).queryParam("type", new Object[]{type}).queryParam("reportCode", new Object[]{reportCode}).build().toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", this.getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmReportDTO>>(){}, new Object[0]);
            return (TmReportDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        }
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    @Override
    @Deprecated
    public List<TmAppDTO> getAppsByProjectIdForTaskEngine(String tmProjectId) {
        String uri = this.envProperties.getWebThemeMapRootUri() + "/restful/standard/datamap/app/projectApps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", tmProjectId);
        List result = null;
        try {
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, new HashMap());
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public List<TmAppDTO> getAppsByProjectIdForFlowEngine(String tmProjectId) {
        String uri = this.envProperties.getWebThemeMapRootUri() + "/restful/service/knowledgegraph/app/appCodeByTaskCode?code={code}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", tmProjectId);
        List result = null;
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, param);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {
        TmActivityResponseDTO result = new TmActivityResponseDTO();
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/activityStartTargetCode?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>(){}, param);
            result = (TmActivityResponseDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        if (result != null) {
            return result.getTargetApproveActivity();
        }
        return null;
    }

    @Override
    public Map getEmailEventIdByLocale(String emailCode, String locale) {
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.envProperties.getWebThemeMapUri() + "knowledgegraph/view/email")).queryParam("emailCode", new Object[]{emailCode}).queryParam("locale", new Object[]{locale}).build().toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException(this.messageUtils.getMessage("exception.KG.email.mould.error"));
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public BusinessKeyDTO getTaskActivityBK(String objectType, String objectValue) {
        BusinessKeyDTO result = null;
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/view/bk";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("objectType", objectType);
        paramMap.put("objectValue", objectValue);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<BusinessKeyDTO>>(){}, new Object[0]);
            result = (BusinessKeyDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        return result;
    }

    @Override
    public JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user) {
        JSONArray result = null;
        String url = "";
        try {
            JSONObject jsonObject;
            url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/view/bk";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("token", user.getToken());
            HashMap<String, String> paramDetailMap = new HashMap<String, String>();
            paramDetailMap.put("objectType", objectType);
            paramDetailMap.put("objectValue", objectValue);
            HashMap<String, HashMap<String, String>> paramMap = new HashMap<String, HashMap<String, String>>();
            paramMap.put("request", paramDetailMap);
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, BaseResultDTO.class, new Object[0]);
            Object response = ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            if (response != null && (jsonObject = JSONObject.fromObject((Object)((BaseResultDTO)responseEntity.getBody()).getResponse())).containsKey((Object)"bkInfo")) {
                result = jsonObject.getJSONArray("bkInfo");
            }
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        return result;
    }

    @Override
    public List<String> getTaskCodeListByAppCode(String appCode) {
        String uri = this.envProperties.getWebThemeMapRootUri() + "/restful/service/knowledgegraph/app/taskCode?appCode={appCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", appCode);
        List result = null;
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<String>>>(){}, param);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
        return result;
    }

    @Override
    public List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes) {
        List result = null;
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/batch/taskBasic";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap rootPara = new HashMap();
        HashMap<String, List<String>> qPara = new HashMap<String, List<String>>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmTaskDefineResponseDTO>>>(){}, rootPara);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }
                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(x.getAssignAble()).assignTo(x.getAssignTo()).build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities) {
        List result = null;
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/batch/activityBasic";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap rootPara = new HashMap();
        HashMap<String, List<Map>> qPara = new HashMap<String, List<Map>>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmActivityResponseDTO>>>(){}, rootPara);
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }
                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder().assignAble(x.getAssignAble()).assignTo(x.getAssignTo()).build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, String> getReportResId(String token, Map params) {
        String url = this.envProperties.getWebThemeMapUri() + "/knowledgegraph/statement/resId";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", token);
        HashMap<String, Map> reqBody = new HashMap<String, Map>();
        reqBody.put("queryObject", params);
        HttpEntity httpEntity = new HttpEntity(reqBody, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, String>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public Map getActivityInputDataDefine(String token, String tmActivityId) {
        String url = this.envProperties.getWebThemeMapUri() + AtmcStrUtil.format("/knowledgegraph/activity/inputData?activityId={tmActivityId}", tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", token);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public TmAppExpireChangeComponentDTO getAppExpireChangeComponent(TmAppExpireChangeComponentDTO appExpireChangeComponent) {
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/Component/QueryComponent";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)appExpireChangeComponent, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmAppExpireChangeComponentDTO>>(){}, new Object[0]);
            if (null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (TmAppExpireChangeComponentDTO)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
            log.error(this.messageUtils.getMessage("exception.KG.overdue.component1"), (Object)appExpireChangeComponent, (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            String errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.KG.overdue.component2"), JsonUtils.objectToString((Object)appExpireChangeComponent), JsonUtils.objectToString((Object)respEntity.getBody()));
            throw BusinessException.create((String)errMsg);
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public TmApplicationDTO getApplicationByCode(String code) {
        TmApplicationDTO result = null;
        String uri = this.envProperties.getWebThemeMapUri() + "knowledgegraph/app/applicationByCode?code={code}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", code);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TmApplicationDTO>>(){}, param);
            result = (TmApplicationDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            return result;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)uri, (Object)e);
            throw e;
        }
    }

    @Override
    public Map<String, String> getAppId(String taskId) {
        Map<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskId", taskId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String getAppIdUrl = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/appSubscription?taskId={taskId}";
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity appIdResponse = this.restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, paramMap);
            Map response = (Map)((BaseResultDTO)appIdResponse.getBody()).getResponseWithException("");
            if (MapUtils.isNotEmpty((Map)response)) {
                resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)response), Map.class);
            }
            return resultMap;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)getAppIdUrl, (Object)e);
            throw e;
        }
    }

    @Override
    public List<Map> getAppInfos(String code) {
        List resultList = new ArrayList<Map>();
        if (StringUtils.isEmpty((String)code)) {
            return resultList;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("code", code);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        String getAppIdUrl = this.envProperties.getWebThemeMapUri() + "knowledgegraph/app/appCodeByTaskCode?code={code}";
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity appIdResponse = this.restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, paramMap);
            List response = (List)((BaseResultDTO)appIdResponse.getBody()).getResponseWithException("");
            if (CollectionUtils.isNotEmpty((Collection)response)) {
                resultList = (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)response), List.class);
            }
            return resultList;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)getAppIdUrl, (Object)e);
            throw e;
        }
    }

    @Override
    public String getRelatedTask(AuthoredUser user, String customTenantId, String activityId) {
        String taskId = "";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/queryRelatedTask";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantId", customTenantId);
        paramMap.put("activityId", activityId);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            Object taskIdObj;
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK && (taskIdObj = ((Map)responseEntity.getBody()).get("response")) != null) {
                taskId = taskIdObj.toString();
            }
            return taskId;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    @Override
    public List<SearchPojo> dealSearch(SearchDto dto) {
        ArrayList<SearchPojo> retList = new ArrayList<SearchPojo>();
        if (null != dto.getType() && dto.getType().equals(-999)) {
            return new ArrayList<SearchPojo>();
        }
        String getAppIdUrl = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/queryItem?condition={itemName}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("itemName", dto.getName());
        JSONArray resultArr = new JSONArray();
        try {
            Object response;
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity entryResp = this.restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, Map.class, param);
            if (entryResp.getStatusCode() == HttpStatus.OK && null != entryResp.getBody() && (response = ((Map)entryResp.getBody()).get("response")) != null && response != "") {
                resultArr = (JSONArray)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), JSONArray.class);
            }
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)getAppIdUrl, (Object)e);
            throw e;
        }
        if (resultArr == null || resultArr.isEmpty()) {
            log.error("query search data with none from km.");
            return retList;
        }
        for (int i = 0; i < resultArr.size(); ++i) {
            SearchPojo pojo = new SearchPojo();
            JSONObject object = resultArr.getJSONObject(i);
            if ("Task".equals(object.getString("type"))) {
                pojo.setType(APPLY_PROJECT_TYPE_STR);
            } else if ("Activity".equals(object.getString("type")) && "STATEMENT".equals(object.getString("pattern")) || "Activity".equals(object.getString("type")) && "DATA_ENTRY".equals(object.getString("pattern"))) continue;
            pojo.setCode(object.getString("code"));
            pojo.setName(object.getString("name"));
            retList.add(pojo);
        }
        return retList;
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {
        String url = this.envProperties.getWebThemeMapUri() + "knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, new Object[0]);
            log.info("[getAppInfoByCodeAndType]  type = {}, codes = {}, result = {}", new Object[]{type, JsonUtils.objectToString(codeList), JsonUtils.objectToString((Object)respEntity)});
        }
        catch (Exception e) {
            log.error("[getAppInfoByCodeAndType] execute km [knowledgegraph/task/applicationRelation] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        return null;
    }
}

