/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.domain.action;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.action.SubmitAction;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskCategory;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskPattern;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class SubmitExecuteContext
implements Serializable {
    private String locale;
    private String clientAgent;
    private String tmProjectId;
    private String tmActivityId;
    private Long backlogId;
    private String processSerialNumber;
    private Map<String, Object> bpmData;
    @JsonIgnore
    private AuthoredUser authoredUser;
    @JsonIgnore
    private AuthoredUser operateAuthoredUser;
    private String proxyToken;
    private String tenantId;
    private String pageCode;
    private String deviceType;
    private String pattern;
    private String category;
    private Map<String, String> businessUnit;
    @JsonIgnore
    private SubmitAction parentAction;
    private String traceId;
    private String dataFrom;
    private Map ptmData;
    private Integer type;
    private Integer taskType;
    private Long abnormalWorkitemId;
    private Integer submitId;
    private Boolean fromAdsc = false;
    private Long projectCardId;
    private Boolean isRetry = false;

    public boolean isPTM() {
        return Objects.equals(this.dataFrom, "PTM");
    }

    public SubmitExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        this.setAuthoredUser(authoredUser);
        if (StringUtils.isEmpty((Object)this.tenantId)) {
            this.setTenantId(authoredUser.getTenantId());
        }
        return this;
    }

    public SubmitExecuteContext appendExecuteContext(SubmitExecuteContext executeContext) {
        this.setClientAgent(executeContext.getClientAgent());
        this.setLocale(executeContext.getLocale());
        this.setAuthoredUser(executeContext.getAuthoredUser());
        this.setTenantId(executeContext.getTenantId());
        this.setDataFrom(executeContext.getDataFrom());
        this.setPtmData(executeContext.getPtmData());
        return this;
    }

    public static SubmitExecuteContext createByHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        SubmitExecuteContext executeContext = SubmitExecuteContext.builder().clientAgent(clientAgent).locale(locale).authoredUser(authoredUser).tenantId(authoredUser.getTenantId()).build();
        return executeContext;
    }

    @JsonIgnore
    public boolean isSolveTask() {
        return Objects.equals(this.getPattern(), TmTaskPattern.BUSINESS.getValue()) && Objects.equals(this.getCategory(), TmTaskCategory.SOLVE.getValue());
    }

    public String toString() {
        return String.format("%s-%s-%s", this.tenantId, this.tmProjectId, this.tmActivityId);
    }

    public static SubmitExecuteContextBuilder builder() {
        return new SubmitExecuteContextBuilder();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getTmProjectId() {
        return this.tmProjectId;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public Long getBacklogId() {
        return this.backlogId;
    }

    public String getProcessSerialNumber() {
        return this.processSerialNumber;
    }

    public Map<String, Object> getBpmData() {
        return this.bpmData;
    }

    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public AuthoredUser getOperateAuthoredUser() {
        return this.operateAuthoredUser;
    }

    public String getProxyToken() {
        return this.proxyToken;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, String> getBusinessUnit() {
        return this.businessUnit;
    }

    public SubmitAction getParentAction() {
        return this.parentAction;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getDataFrom() {
        return this.dataFrom;
    }

    public Map getPtmData() {
        return this.ptmData;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Long getAbnormalWorkitemId() {
        return this.abnormalWorkitemId;
    }

    public Integer getSubmitId() {
        return this.submitId;
    }

    public Boolean getFromAdsc() {
        return this.fromAdsc;
    }

    public Long getProjectCardId() {
        return this.projectCardId;
    }

    public Boolean getIsRetry() {
        return this.isRetry;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setTmProjectId(String tmProjectId) {
        this.tmProjectId = tmProjectId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public void setBacklogId(Long backlogId) {
        this.backlogId = backlogId;
    }

    public void setProcessSerialNumber(String processSerialNumber) {
        this.processSerialNumber = processSerialNumber;
    }

    public void setBpmData(Map<String, Object> bpmData) {
        this.bpmData = bpmData;
    }

    @JsonIgnore
    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    @JsonIgnore
    public void setOperateAuthoredUser(AuthoredUser operateAuthoredUser) {
        this.operateAuthoredUser = operateAuthoredUser;
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setBusinessUnit(Map<String, String> businessUnit) {
        this.businessUnit = businessUnit;
    }

    @JsonIgnore
    public void setParentAction(SubmitAction parentAction) {
        this.parentAction = parentAction;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setDataFrom(String dataFrom) {
        this.dataFrom = dataFrom;
    }

    public void setPtmData(Map ptmData) {
        this.ptmData = ptmData;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setAbnormalWorkitemId(Long abnormalWorkitemId) {
        this.abnormalWorkitemId = abnormalWorkitemId;
    }

    public void setSubmitId(Integer submitId) {
        this.submitId = submitId;
    }

    public void setFromAdsc(Boolean fromAdsc) {
        this.fromAdsc = fromAdsc;
    }

    public void setProjectCardId(Long projectCardId) {
        this.projectCardId = projectCardId;
    }

    public void setIsRetry(Boolean isRetry) {
        this.isRetry = isRetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmitExecuteContext)) {
            return false;
        }
        SubmitExecuteContext other = (SubmitExecuteContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$backlogId = this.getBacklogId();
        Long other$backlogId = other.getBacklogId();
        if (this$backlogId == null ? other$backlogId != null : !((Object)this$backlogId).equals(other$backlogId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Long this$abnormalWorkitemId = this.getAbnormalWorkitemId();
        Long other$abnormalWorkitemId = other.getAbnormalWorkitemId();
        if (this$abnormalWorkitemId == null ? other$abnormalWorkitemId != null : !((Object)this$abnormalWorkitemId).equals(other$abnormalWorkitemId)) {
            return false;
        }
        Integer this$submitId = this.getSubmitId();
        Integer other$submitId = other.getSubmitId();
        if (this$submitId == null ? other$submitId != null : !((Object)this$submitId).equals(other$submitId)) {
            return false;
        }
        Boolean this$fromAdsc = this.getFromAdsc();
        Boolean other$fromAdsc = other.getFromAdsc();
        if (this$fromAdsc == null ? other$fromAdsc != null : !((Object)this$fromAdsc).equals(other$fromAdsc)) {
            return false;
        }
        Long this$projectCardId = this.getProjectCardId();
        Long other$projectCardId = other.getProjectCardId();
        if (this$projectCardId == null ? other$projectCardId != null : !((Object)this$projectCardId).equals(other$projectCardId)) {
            return false;
        }
        Boolean this$isRetry = this.getIsRetry();
        Boolean other$isRetry = other.getIsRetry();
        if (this$isRetry == null ? other$isRetry != null : !((Object)this$isRetry).equals(other$isRetry)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$clientAgent = this.getClientAgent();
        String other$clientAgent = other.getClientAgent();
        if (this$clientAgent == null ? other$clientAgent != null : !this$clientAgent.equals(other$clientAgent)) {
            return false;
        }
        String this$tmProjectId = this.getTmProjectId();
        String other$tmProjectId = other.getTmProjectId();
        if (this$tmProjectId == null ? other$tmProjectId != null : !this$tmProjectId.equals(other$tmProjectId)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        String this$processSerialNumber = this.getProcessSerialNumber();
        String other$processSerialNumber = other.getProcessSerialNumber();
        if (this$processSerialNumber == null ? other$processSerialNumber != null : !this$processSerialNumber.equals(other$processSerialNumber)) {
            return false;
        }
        Map<String, Object> this$bpmData = this.getBpmData();
        Map<String, Object> other$bpmData = other.getBpmData();
        if (this$bpmData == null ? other$bpmData != null : !((Object)this$bpmData).equals(other$bpmData)) {
            return false;
        }
        AuthoredUser this$authoredUser = this.getAuthoredUser();
        AuthoredUser other$authoredUser = other.getAuthoredUser();
        if (this$authoredUser == null ? other$authoredUser != null : !this$authoredUser.equals(other$authoredUser)) {
            return false;
        }
        AuthoredUser this$operateAuthoredUser = this.getOperateAuthoredUser();
        AuthoredUser other$operateAuthoredUser = other.getOperateAuthoredUser();
        if (this$operateAuthoredUser == null ? other$operateAuthoredUser != null : !this$operateAuthoredUser.equals(other$operateAuthoredUser)) {
            return false;
        }
        String this$proxyToken = this.getProxyToken();
        String other$proxyToken = other.getProxyToken();
        if (this$proxyToken == null ? other$proxyToken != null : !this$proxyToken.equals(other$proxyToken)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$pageCode = this.getPageCode();
        String other$pageCode = other.getPageCode();
        if (this$pageCode == null ? other$pageCode != null : !this$pageCode.equals(other$pageCode)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        Map<String, String> this$businessUnit = this.getBusinessUnit();
        Map<String, String> other$businessUnit = other.getBusinessUnit();
        if (this$businessUnit == null ? other$businessUnit != null : !((Object)this$businessUnit).equals(other$businessUnit)) {
            return false;
        }
        SubmitAction this$parentAction = this.getParentAction();
        SubmitAction other$parentAction = other.getParentAction();
        if (this$parentAction == null ? other$parentAction != null : !((Object)this$parentAction).equals(other$parentAction)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$dataFrom = this.getDataFrom();
        String other$dataFrom = other.getDataFrom();
        if (this$dataFrom == null ? other$dataFrom != null : !this$dataFrom.equals(other$dataFrom)) {
            return false;
        }
        Map this$ptmData = this.getPtmData();
        Map other$ptmData = other.getPtmData();
        return !(this$ptmData == null ? other$ptmData != null : !((Object)this$ptmData).equals(other$ptmData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubmitExecuteContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $backlogId = this.getBacklogId();
        result = result * 59 + ($backlogId == null ? 43 : ((Object)$backlogId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Long $abnormalWorkitemId = this.getAbnormalWorkitemId();
        result = result * 59 + ($abnormalWorkitemId == null ? 43 : ((Object)$abnormalWorkitemId).hashCode());
        Integer $submitId = this.getSubmitId();
        result = result * 59 + ($submitId == null ? 43 : ((Object)$submitId).hashCode());
        Boolean $fromAdsc = this.getFromAdsc();
        result = result * 59 + ($fromAdsc == null ? 43 : ((Object)$fromAdsc).hashCode());
        Long $projectCardId = this.getProjectCardId();
        result = result * 59 + ($projectCardId == null ? 43 : ((Object)$projectCardId).hashCode());
        Boolean $isRetry = this.getIsRetry();
        result = result * 59 + ($isRetry == null ? 43 : ((Object)$isRetry).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $clientAgent = this.getClientAgent();
        result = result * 59 + ($clientAgent == null ? 43 : $clientAgent.hashCode());
        String $tmProjectId = this.getTmProjectId();
        result = result * 59 + ($tmProjectId == null ? 43 : $tmProjectId.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        String $processSerialNumber = this.getProcessSerialNumber();
        result = result * 59 + ($processSerialNumber == null ? 43 : $processSerialNumber.hashCode());
        Map<String, Object> $bpmData = this.getBpmData();
        result = result * 59 + ($bpmData == null ? 43 : ((Object)$bpmData).hashCode());
        AuthoredUser $authoredUser = this.getAuthoredUser();
        result = result * 59 + ($authoredUser == null ? 43 : $authoredUser.hashCode());
        AuthoredUser $operateAuthoredUser = this.getOperateAuthoredUser();
        result = result * 59 + ($operateAuthoredUser == null ? 43 : $operateAuthoredUser.hashCode());
        String $proxyToken = this.getProxyToken();
        result = result * 59 + ($proxyToken == null ? 43 : $proxyToken.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $pageCode = this.getPageCode();
        result = result * 59 + ($pageCode == null ? 43 : $pageCode.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        Map<String, String> $businessUnit = this.getBusinessUnit();
        result = result * 59 + ($businessUnit == null ? 43 : ((Object)$businessUnit).hashCode());
        SubmitAction $parentAction = this.getParentAction();
        result = result * 59 + ($parentAction == null ? 43 : ((Object)$parentAction).hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $dataFrom = this.getDataFrom();
        result = result * 59 + ($dataFrom == null ? 43 : $dataFrom.hashCode());
        Map $ptmData = this.getPtmData();
        result = result * 59 + ($ptmData == null ? 43 : ((Object)$ptmData).hashCode());
        return result;
    }

    public SubmitExecuteContext(String locale, String clientAgent, String tmProjectId, String tmActivityId, Long backlogId, String processSerialNumber, Map<String, Object> bpmData, AuthoredUser authoredUser, AuthoredUser operateAuthoredUser, String proxyToken, String tenantId, String pageCode, String deviceType, String pattern, String category, Map<String, String> businessUnit, SubmitAction parentAction, String traceId, String dataFrom, Map ptmData, Integer type, Integer taskType, Long abnormalWorkitemId, Integer submitId, Boolean fromAdsc, Long projectCardId, Boolean isRetry) {
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.tmProjectId = tmProjectId;
        this.tmActivityId = tmActivityId;
        this.backlogId = backlogId;
        this.processSerialNumber = processSerialNumber;
        this.bpmData = bpmData;
        this.authoredUser = authoredUser;
        this.operateAuthoredUser = operateAuthoredUser;
        this.proxyToken = proxyToken;
        this.tenantId = tenantId;
        this.pageCode = pageCode;
        this.deviceType = deviceType;
        this.pattern = pattern;
        this.category = category;
        this.businessUnit = businessUnit;
        this.parentAction = parentAction;
        this.traceId = traceId;
        this.dataFrom = dataFrom;
        this.ptmData = ptmData;
        this.type = type;
        this.taskType = taskType;
        this.abnormalWorkitemId = abnormalWorkitemId;
        this.submitId = submitId;
        this.fromAdsc = fromAdsc;
        this.projectCardId = projectCardId;
        this.isRetry = isRetry;
    }

    public SubmitExecuteContext() {
    }

    public static class SubmitExecuteContextBuilder {
        private String locale;
        private String clientAgent;
        private String tmProjectId;
        private String tmActivityId;
        private Long backlogId;
        private String processSerialNumber;
        private Map<String, Object> bpmData;
        private AuthoredUser authoredUser;
        private AuthoredUser operateAuthoredUser;
        private String proxyToken;
        private String tenantId;
        private String pageCode;
        private String deviceType;
        private String pattern;
        private String category;
        private Map<String, String> businessUnit;
        private SubmitAction parentAction;
        private String traceId;
        private String dataFrom;
        private Map ptmData;
        private Integer type;
        private Integer taskType;
        private Long abnormalWorkitemId;
        private Integer submitId;
        private Boolean fromAdsc;
        private Long projectCardId;
        private Boolean isRetry;

        SubmitExecuteContextBuilder() {
        }

        public SubmitExecuteContextBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public SubmitExecuteContextBuilder clientAgent(String clientAgent) {
            this.clientAgent = clientAgent;
            return this;
        }

        public SubmitExecuteContextBuilder tmProjectId(String tmProjectId) {
            this.tmProjectId = tmProjectId;
            return this;
        }

        public SubmitExecuteContextBuilder tmActivityId(String tmActivityId) {
            this.tmActivityId = tmActivityId;
            return this;
        }

        public SubmitExecuteContextBuilder backlogId(Long backlogId) {
            this.backlogId = backlogId;
            return this;
        }

        public SubmitExecuteContextBuilder processSerialNumber(String processSerialNumber) {
            this.processSerialNumber = processSerialNumber;
            return this;
        }

        public SubmitExecuteContextBuilder bpmData(Map<String, Object> bpmData) {
            this.bpmData = bpmData;
            return this;
        }

        @JsonIgnore
        public SubmitExecuteContextBuilder authoredUser(AuthoredUser authoredUser) {
            this.authoredUser = authoredUser;
            return this;
        }

        @JsonIgnore
        public SubmitExecuteContextBuilder operateAuthoredUser(AuthoredUser operateAuthoredUser) {
            this.operateAuthoredUser = operateAuthoredUser;
            return this;
        }

        public SubmitExecuteContextBuilder proxyToken(String proxyToken) {
            this.proxyToken = proxyToken;
            return this;
        }

        public SubmitExecuteContextBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SubmitExecuteContextBuilder pageCode(String pageCode) {
            this.pageCode = pageCode;
            return this;
        }

        public SubmitExecuteContextBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public SubmitExecuteContextBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public SubmitExecuteContextBuilder category(String category) {
            this.category = category;
            return this;
        }

        public SubmitExecuteContextBuilder businessUnit(Map<String, String> businessUnit) {
            this.businessUnit = businessUnit;
            return this;
        }

        @JsonIgnore
        public SubmitExecuteContextBuilder parentAction(SubmitAction parentAction) {
            this.parentAction = parentAction;
            return this;
        }

        public SubmitExecuteContextBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SubmitExecuteContextBuilder dataFrom(String dataFrom) {
            this.dataFrom = dataFrom;
            return this;
        }

        public SubmitExecuteContextBuilder ptmData(Map ptmData) {
            this.ptmData = ptmData;
            return this;
        }

        public SubmitExecuteContextBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public SubmitExecuteContextBuilder taskType(Integer taskType) {
            this.taskType = taskType;
            return this;
        }

        public SubmitExecuteContextBuilder abnormalWorkitemId(Long abnormalWorkitemId) {
            this.abnormalWorkitemId = abnormalWorkitemId;
            return this;
        }

        public SubmitExecuteContextBuilder submitId(Integer submitId) {
            this.submitId = submitId;
            return this;
        }

        public SubmitExecuteContextBuilder fromAdsc(Boolean fromAdsc) {
            this.fromAdsc = fromAdsc;
            return this;
        }

        public SubmitExecuteContextBuilder projectCardId(Long projectCardId) {
            this.projectCardId = projectCardId;
            return this;
        }

        public SubmitExecuteContextBuilder isRetry(Boolean isRetry) {
            this.isRetry = isRetry;
            return this;
        }

        public SubmitExecuteContext build() {
            return new SubmitExecuteContext(this.locale, this.clientAgent, this.tmProjectId, this.tmActivityId, this.backlogId, this.processSerialNumber, this.bpmData, this.authoredUser, this.operateAuthoredUser, this.proxyToken, this.tenantId, this.pageCode, this.deviceType, this.pattern, this.category, this.businessUnit, this.parentAction, this.traceId, this.dataFrom, this.ptmData, this.type, this.taskType, this.abnormalWorkitemId, this.submitId, this.fromAdsc, this.projectCardId, this.isRetry);
        }

        public String toString() {
            return "SubmitExecuteContext.SubmitExecuteContextBuilder(locale=" + this.locale + ", clientAgent=" + this.clientAgent + ", tmProjectId=" + this.tmProjectId + ", tmActivityId=" + this.tmActivityId + ", backlogId=" + this.backlogId + ", processSerialNumber=" + this.processSerialNumber + ", bpmData=" + this.bpmData + ", authoredUser=" + this.authoredUser + ", operateAuthoredUser=" + this.operateAuthoredUser + ", proxyToken=" + this.proxyToken + ", tenantId=" + this.tenantId + ", pageCode=" + this.pageCode + ", deviceType=" + this.deviceType + ", pattern=" + this.pattern + ", category=" + this.category + ", businessUnit=" + this.businessUnit + ", parentAction=" + this.parentAction + ", traceId=" + this.traceId + ", dataFrom=" + this.dataFrom + ", ptmData=" + this.ptmData + ", type=" + this.type + ", taskType=" + this.taskType + ", abnormalWorkitemId=" + this.abnormalWorkitemId + ", submitId=" + this.submitId + ", fromAdsc=" + this.fromAdsc + ", projectCardId=" + this.projectCardId + ", isRetry=" + this.isRetry + ")";
        }
    }
}

