/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.bpm.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowProcess;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<WorkflowProcess> getWorkflowProcessList(String serialNumber, String workItemId) {
        Object list;
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("serialNumber", serialNumber);
        paramMap.put("workItemId", workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String getAppIdUrl = this.envProperties.getWorkflowUri() + "api/process/activity/history";
        HttpEntity httpEntity = new HttpEntity((Object)paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(getAppIdUrl, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
        Map responseWithException = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        Map dataMap = MapUtils.getMap((Map)responseWithException, (Object)"data");
        if (dataMap != null && (list = dataMap.get("list")) instanceof List) {
            return JsonUtils.jsonToListObject((String)JsonUtils.objectToString(list), WorkflowProcess.class);
        }
        return Collections.emptyList();
    }
}

