/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.bpm.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public Map<String, Object> getWorkflowProcess(String serialNumber, String workItemId) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("serialNumber", serialNumber);
        paramMap.put("workItemId", workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String getAppIdUrl = this.envProperties.getWorkflowUri() + "api/process/activity/history";
        HttpEntity httpEntity = new HttpEntity((Object)paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(getAppIdUrl, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
        BaseResultDTO body = (BaseResultDTO)responseEntity.getBody();
        if (body != null) {
            return (Map)body.getResponse();
        }
        return null;
    }
}

