package com.digiwin.athena.atmc.http.domain;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 待办卡业务数据
 *
 * @Author hejy
 * @Version 1.0
 * @Date 2024/4/28 14:24
 */
@Getter
@Setter
@Accessors(chain = true)
public class BacklogCardField {

    /**
     * 卡id
     */
    private Long cardId;

    /**
     * 页面类型
     */
    private String pageCode;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 业务数据集合
     */
    private List<Map<String, LinkedHashSet<Object>>> valueList;

}
