package com.digiwin.athena.atmc.http.restful.audc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.AudcApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.audc.model.FunctionPermissionDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.digiwin.athena.atmc.http.restful.audc.AudcService;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesAccessibleDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesDTO;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author：SYQ
 * @date：2022/1/11
 */
@Slf4j
@Service
public class AudcServiceImpl implements AudcService {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public Map<String, Object> deleteByTenantId(AuthoredUser authoredUser, String tenantId) {
        //结果
        Map<String, Object> resultMap = new HashMap<>();
        //租户id不能为空
        if (StringUtil.isEmpty(tenantId)) {
            return resultMap;
        }

        String uri = envProperties.getAudcUri() + AtmcStrUtil.format(AudcApiConstant.COFW_DELETE_BY_TENANT_TENANT_ID, tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultMap = responseEntity.getBody().getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), responseEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultMap;
    }

    /**
     * 清除缓存
     */
    @Override
    public void clearCache() {
        String url = envProperties.getAudcUri() + AudcApiConstant.CACHE_RESET;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity<BaseResultDTO<Object>> reqEntity = new HttpEntity<>(null, headers);
        ResponseEntity<BaseResultDTO<Object>> respEntity = restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Object>>() {
        });
        // 请求失败，直接抛出异常
        respEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<TypeActivitiesAccessibleDTO> checkAccessActivity(AuthoredUser authoredUser, List<TypeActivitiesDTO> typeActivitiesList) {
        //结果
        List<TypeActivitiesAccessibleDTO> resultList = Lists.newArrayList();
        //租户id不能为空
        if (CollectionUtils.isEmpty(typeActivitiesList)) {
            return resultList;
        }

        String uri = envProperties.getAudcUri() + "/api/audc/v1/check/activity/accessible";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        HttpEntity<?> httpEntity = new HttpEntity<>(JsonUtils.objectToString(typeActivitiesList), headers);
        try {
            ResponseEntity<BaseResultDTO<List<TypeActivitiesAccessibleDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TypeActivitiesAccessibleDTO>>>() {
                    });
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultList = Objects.requireNonNull(responseEntity.getBody()).getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), responseEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultList;
    }

    @Override
    public List<FunctionPermissionDTO> checkUserAppAccess(AuthoredUser authoredUser,String appCode) {
        //结果
        List<FunctionPermissionDTO> resultList = Lists.newArrayList();

        String uri = envProperties.getAudcUri() + "/api/audc/v1/user/authored/app/permission/appCode?appCode=" + appCode;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        try {
            HttpEntity<BaseResultDTO<List<FunctionPermissionDTO>>> reqEntity = new HttpEntity<>(null, headers);
            ResponseEntity<BaseResultDTO<List<FunctionPermissionDTO>>> respEntity = restTemplate.exchange(uri, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<List<FunctionPermissionDTO>>>() {
            });
            // 请求失败，直接抛出异常
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                resultList = Objects.requireNonNull(respEntity.getBody()).getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), reqEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultList;
    }

}
