package com.digiwin.athena.atmc.http.restful.bpm;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoCreateDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.ForecatedUserTaskDTO;

import java.util.List;
import java.util.Map;

public interface BpmService {

   void dispatch(String processSerialNumber,String workitemId,String performerId);

   void terminateProcess(String processSerialNumber,String workitemId,String performerId);

   /**
    * 获取预测关卡
    * @param processSerialNumber
    * @param tmActivityId
    */
   BaseResultDTO<List<ForecatedUserTaskDTO>> getForecastedUsertask(String processSerialNumber, String tmActivityId);

   /**
    * 转派
    * @param processSerialNumber
    * @param bpmActivityId
    * @param workitemId
    * @param oldPerformerId
    * @param newPerformerId
    * @param comment
    */
   void reassignWorkitem(String processSerialNumber, String bpmActivityId, String workitemId,String oldPerformerId, String newPerformerId, String comment);

   /**
    * 重置指定租户的数据
    * @param tenantId
    * @return
    */
   BaseResultDTO resetTenantData(String tenantId);

   /**
    * 直接更换工作项目的执行人，目前用于 合并后的任务转派
    * @param workitems
    */
   BaseResultDTO<Map> updatePerformer(Map workitems);

   /**
    * bpm 录制数量
    * @param tenantId
    * @return
    */
   DemoItemResultDTO bpmRecordData(String tenantId);


   /**
    * bpm 清除数据
    * @param tenantId
    * @return
    */
   DemoItemResultDTO bpmDeleteData(String tenantId);

   /**
    * bpm 录制数量
    * @param dto
    * @return
    */
   DemoItemResultDTO bpmCreateData(DemoCreateDTO dto);
}
