package com.digiwin.athena.atmc.http.restful.cac;

import java.util.List;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.cac.model.UserAppDTO;

public interface CacService {

    /**
     * 检查指定用户的指定应用 在当前租户是否有授权
     * @param userId
     * @param appCode
     * @return
     */
    AppAuthDTO queryAppAuth(String userId, String appCode);


    /**
     * 查询当前登录用户所有的应用权限
     * @return
     */
    List<UserAppDTO> qryUserApp();



    /**
     * 查询应用下授权人员
     * @param appCode
     * @return
     */
    List<String> queryUserByAppCode(String appCode);

    /**
     * 根据userId查询用户信息
     * @return
     */
    List<UserAppDTO> qryUserAppByUserId(String userId);

}
