package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * PTM签核历程
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmBacklogApprovalDTO {

    /**
     * 发起人信息
     */
    private String initiator;
    private LocalDateTime initiatorCreateTime;
    private LocalDateTime initiatorClosedTime;
    private String projectDefCode;
    private String taskDefCode;
    private List<SignProcess> signProcess;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class SignProcess{
        /**
         * 是否发起人节点
         */
        private Boolean initiatorNode;
        /**
         * 发起人id，isInitiator=true是必传
         */
        private String initiatorId;
        private String bpmActivityOID;
        private String activityId;
        private String activityName;
        private String signType;
        private LocalDateTime startTime;
        private LocalDateTime completedTime;
        private Map informer;
        private Integer state;
        private Integer subState;
        private List<WorkItem> workitemList;
        private String noticeInformer;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem{
        private String workitemId;
        private String agentPerformerId;
        private Integer subState;
        private LocalDateTime createTime;
        private String performerName;
        private Integer createType;
        private String comment;
        private Integer state;
        private String performerId;
        private Integer performerType;
        private LocalDateTime closedTime;
        private List<ApprovelAttachmentDTO> attachments;
    }


}
