package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 需发送line消息的任务
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PtmLineBacklogDTO {
    /**
     * 任务集合
     */
    private List<BacklogData> data;

    /**
     * 任务详情
     */
    @Data
    public static class BacklogData {
        /**
         * 任务卡id
         */
        private Long id;

        /**
         * 任务执行人
         */
        private String performerId;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 代理token
         */
        private String proxyToken;

        /**
         * 任务名称
         */
        private String name;
    }
}
