package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 项目卡中路线的 任务信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardRouteTaskDTO {

    private Long id;
    private Long activityId;
    private Long projectId;
    private Long projectCardId;
    private String preTaskUid;
    private String taskName;
    private String taskDefCode;
    private String taskDefCategory;
    private String taskDefPattern;
    private String taskDefExecuteType;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private LocalDateTime planEndTime;
    private String bpmnType;
    private String tenantId;
    private Integer state;
    private Integer subState;
    Map data;
    List<BacklogDTO> backlogs;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class BacklogDTO {
        /**
         * backlog.id
         */
        private Long id;

        /**
         * backlog.type<br>
         * 0-默认；1-l辅助执行者；2-跨租户
         */
        private Integer type;

        /**
         * workitem.id
         */
        private Long workItemKey;

        private Long activityId;
        private String workitemId;
        private Integer createType;
        private String performerId;
        private Integer performerType;
        private String performerName;
        private Integer state;
        private Integer subState;
    }
}
