package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmTaskReportItemDTO {

    private Long id;
    private String projectName;
    private LocalDateTime createTime;
    private String personInCharge;
    private String personInChargeName;
    private Integer state;
    private LocalDateTime closedTime;
    private String projectDefCode;
    private Map businessUnit;
    private List<WorkItem> workitemList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem{
        private Long id;
        private Long backlogId;
        private String taskName;
        private String taskDefCode;
        private Integer state;
        private LocalDateTime planEndTime;
        private LocalDateTime closedTime;
    }

}
