/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.abt.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.abt.AbtService;
import com.digiwin.athena.atmc.http.restful.abt.model.NoticeAbtRepairDto;
import com.digiwin.athena.atmc.http.restful.abt.model.RefreshCardMessageDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AbtServiceImpl
implements AbtService {
    private static final Logger log = LoggerFactory.getLogger(AbtServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void createRefreshCardMessageJob(RefreshCardMessageDTO refreshCardMessageDTO) {
        String url = this.envProperties.getAbtUri() + "/api/abt/v1/refresh/card/message/job/createIfAbsent";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        log.info("create refresh card message job{}, {}", (Object)refreshCardMessageDTO.getId(), (Object)refreshCardMessageDTO);
        Boolean success = this.httpAssistantService.post(new TypeReference<Boolean>(){}, url, headers, refreshCardMessageDTO);
        log.info("create refresh card message job{}, {}, ret{}", new Object[]{refreshCardMessageDTO.getId(), refreshCardMessageDTO, success});
    }

    @Override
    public void noticeRepairApcData(NoticeAbtRepairDto dto) {
        log.info("AbtServiceImpl.noticeRepairApcData{}", (Object)dto);
        String url = this.envProperties.getAbtUri() + "/api/abt/v1/notice/repairData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            if (respEntity.getStatusCode().value() != 200 || !((BaseResultDTO)respEntity.getBody()).isOK()) {
                log.error("Failed to request abt to noticeRepairApcData \uff0cstatusCode: {}, responseBody: {}.", (Object)respEntity.getStatusCode().value(), respEntity.getBody());
            }
        }
        catch (Exception ex) {
            log.error("Failed to request abt to noticeRepairApcData\uff0cerror: {}.", (Throwable)ex);
        }
    }

    @Override
    public Boolean historyStartDownload(Map<String, Object> paramMap) {
        String url = this.envProperties.getAbtUri() + "/api/abt/v1/baseDataEntry/historyStartDownload";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        log.info("do historyStartDownload,params:{}", (Object)JsonUtils.objectToString(paramMap));
        Boolean success = this.httpAssistantService.post(new TypeReference<Boolean>(){}, url, headers, paramMap);
        return success;
    }
}

