/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.bpm.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.domain.misc.DemoCreateDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.bpm.BpmService;
import com.digiwin.athena.atmc.http.restful.bpm.model.ForecatedUserTaskDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class BpmServiceImpl
implements BpmService {
    private static final Logger log = LoggerFactory.getLogger(BpmServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void dispatch(String processSerialNumber, String workitemId, String performerId) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        String serviceUri = this.envProperties.getBpmUri() + "v1/process-engine/tasks/dispatch-user-task";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processSerialNumber", processSerialNumber);
        map.put("workitemId", workitemId);
        map.put("performerId", performerId);
        map.put("agentPerformerId", performerId);
        map.put("comment", "");
        map.put("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public void terminateProcess(String processSerialNumber, String workitemId, String performerId) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        String serviceUri = this.envProperties.getBpmUri() + "v1/process-engine/process-instances/terminate-process";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processSerialNumber", processSerialNumber);
        map.put("workitemId", workitemId);
        map.put("performerId", performerId);
        map.put("comment", "\u56e0\u4e3a\u6240\u6709\u5f02\u5e38\u6392\u9664\u90fd\u5df2\u7ecf\u7ed3\u675f\u4e86\uff0c\u7ec8\u6b62\u6d41\u7a0b");
        map.put("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        try {
            this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (HttpServerErrorException.InternalServerError internalServerError) {
            Map response;
            String message = internalServerError.getResponseBodyAsString();
            if (StringUtils.isNotBlank((String)message) && (response = (Map)JsonUtils.jsonToObject((String)message, Map.class)) != null && response.containsKey("errorCode") && Objects.equals(response.get("errorCode"), "70930")) {
                return;
            }
            throw internalServerError;
        }
    }

    @Override
    public BaseResultDTO<List<ForecatedUserTaskDTO>> getForecastedUsertask(String processSerialNumber, String tmActivityId) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        String serviceUri = this.envProperties.getBpmUri() + "/v1/athena/process-engine/process-instances/get-forecasted-usertask";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processSerialNumber", processSerialNumber);
        ArrayList<String> list = new ArrayList<String>();
        list.add(tmActivityId);
        map.put("tmActivityIds", list);
        map.put("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ForecatedUserTaskDTO>>>(){}, new Object[0]);
        if (((BaseResultDTO)responseEntity.getBody()).isOK()) {
            return (BaseResultDTO)responseEntity.getBody();
        }
        return null;
    }

    @Override
    public void reassignWorkitem(String processSerialNumber, String bpmActivityId, String workitemId, String oldPerformerId, String newPerformerId, String comment) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        String serviceUri = this.envProperties.getBpmUri() + "v1/process-engine/workitems/reassign-workitem";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processSerialNumber", processSerialNumber);
        map.put("taskId", bpmActivityId);
        map.put("workitemId", workitemId);
        map.put("performerId", oldPerformerId);
        map.put("newPerformerId", newPerformerId);
        map.put("comment", comment);
        map.put("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public BaseResultDTO resetTenantData(String tenantId) {
        String serviceUri = this.envProperties.getBpmUri() + "v1/process-demo/demo-data/import";
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("importTenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map> updatePerformer(Map workitems) {
        String serviceUri = this.envProperties.getBpmUri() + "v1/process-engine/workitems/update-workitems";
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity httpEntity = new HttpEntity((Object)workitems, (MultiValueMap)headerMap);
        ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public DemoItemResultDTO bpmRecordData(String tenantId) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("Bpm \u5f55\u5236\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String serviceUri = this.envProperties.getBpmUri() + "v1/process-demo/demo-data/export";
            HttpHeaders headerMap = new HttpHeaders();
            headerMap.add("Content-Type", "application/json;charset=UTF-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("exportTenantId", tenantId);
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
            ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            if (!((BaseResultDTO)responseEntity.getBody()).isOK()) {
                result.setSuccess(false);
                msgList.add("----\u5f55\u5236 Bpm \u7684\u6570\u636e\u51fa\u73b0\u5f02\u5e38,\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
                log.error("[\u5f55\u5236 Bpm]", responseEntity.getBody());
            }
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("Bpm \u5f55\u5236\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[Bpm \u5f55\u5236\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public DemoItemResultDTO bpmDeleteData(String tenantId) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("Bpm \u6e05\u9664\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String serviceUri = this.envProperties.getBpmUri() + "/v1/process-demo/demo-data/clear-instance";
            HttpHeaders headerMap = new HttpHeaders();
            headerMap.add("Content-Type", "application/json;charset=UTF-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("delTenantId", tenantId);
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
            this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("Bpm \u6e05\u9664\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[Bpm \u6e05\u9664\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public DemoItemResultDTO bpmCreateData(DemoCreateDTO dto) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("Bpm \u91cd\u7f6e\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String serviceUri = this.envProperties.getBpmUri() + "v1/process-demo/demo-data/import";
            HttpHeaders headerMap = new HttpHeaders();
            headerMap.add("Content-Type", "application/json;charset=UTF-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fromDemoTenantId", dto.getSourceTenantId());
            map.put("importTenantId", dto.getTargetTenantId());
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
            this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("Bpm \u91cd\u7f6e\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[Bpm \u91cd\u7f6e\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }
}

