package com.digiwin.athena.atmc.infrastructure.mapper.biz.migration;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.*;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.Backlog;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.CalendarQueryParamDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public interface BacklogMapper extends BaseMapper<Backlog> {
    /**
     * 查询指定用户的非行事历待办项列表
     *
     * @param userIdList
     * @param tenantId
     * @return
     */
    List<BacklogBO> selectAllNotCalendarBacklogByAndUserIdList(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId,
                                                               @Param("nowTime") String nowTime, @Param("startTime") String startTime,
                                                               @Param("endTime") String endTime, @Param(("completed")) Boolean completed);

    /**
     * 根据待办项id列表查询所有为关闭（state<5）的待办项列表
     *
     * @param workItemList
     * @param tenantId
     * @return
     */
    List<BacklogBO> selectUnDeleteByWorkItemList(@Param("workItemList") List<Long> workItemList, @Param("tenantId") String tenantId,
                                                 @Param("nowTime") String nowTime);

    /**
     * 根据待办项id列表查询所有为关闭（state<5）的待办项列表
     *
     * @param workItemList
     * @param tenantId
     * @param mainProjectId
     * @return
     */
    List<BacklogBO> selectUnDeleteByIdAndProcessSerialNumber(@Param("tenantId") String tenantId, @Param("mainProjectId") Long mainProjectId,
                                                             @Param("workItemList") List<Long> workItemList, @Param("nowTime") String nowTime);

    /**
     * 查询指定用户的所有待办项列表
     *
     * @param userIdList
     * @param tenantId
     * @return
     */
    List<BacklogBO> selectAllBacklogByAndUserIdList(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId, @Param("nowTime") String nowTime);

    List<BacklogBO> selectByNotClosedAndUserId(@Param("userIds") List<String> userIds, @Param("tenantId") String tenantId, @Param("nowTime") String nowTime);


    /**
     * 根据任务id获取任务卡的所有资讯
     *
     * @param workItemId
     * @return
     */
    BacklogBO selectByWorkItemId(@Param("workItemId") Long workItemId, @Param("nowTime") String nowTime);

    Backlog selectByIdAndNotClosed(@Param("id") Long id);

    int updateClosedByBpmActivityId(Backlog record);

    ActivityDataBO getActivityDataByBacklogId(Long workitemId);

    List<ActivityDataBO> getActivityDatasByBacklogId(Long workitemId);

    /**
     * 兼容旧有的消息、邮件，预计迭代10可以去掉这段逻辑
     *
     * @param backlogId
     * @return
     */
    ActivityDataBO getActivityDataBy4BacklogId(Long backlogId);

    Map getBacklogDetail(@Param("workItemId") Long workItemId, @Param("nowTime") String nowTime);

    /**
     * 获取任务信息（返回bpm_activity_step.data信息），适用于报表
     *
     * @param workItemId
     * @return
     */
    Map getBacklogDetailForReport(@Param("workItemId") Long workItemId, @Param("nowTime") String nowTime);

    /**
     * 兼容旧有的消息、邮件，预计迭代10可以去掉这段逻辑
     *
     * @param backlogId
     * @return
     */
    Map getBacklogDetail4BacklogId(Long backlogId, Boolean mainWorkItem);

    List<Map<String, Object>> getGroupByActivityName(@Param("userId") String userId, @Param("tenantId") String tenantId);

    List<BacklogPerformerBO> selectByTmActivityIdAndNotClosed(@Param("tmActivityId") String tmActivityId, @Param("mainTaskId") Long mainTaskId);

    List<BacklogPerformerBO> selectByActivityIdAndNotClosed(@Param("activityId") Long activityId, @Param("taskId") Long taskId);

    /**
     * 根据待办项ID，清空其关联的bpm_activity表的data字段
     *
     * @param backlogId
     * @return
     */
    @Update("update bpm_activity \n" +
            "inner join backlog on bpm_activity.id=backlog.bpm_activity_id\n" +
            "set bpm_activity.data = null\n" +
            "where backlog.id=#{backlogId} ")
    int clearBpmActivityDataByBacklogId(@Param("backlogId") long backlogId);

    @Select("select * from backlog where bpm_activity_step_id=#{bpmActivityStepId} limit 1")
    Backlog selectFirstByActivityStepId(@Param("bpmActivityStepId") Long bpmActivityStepId);

    BacklogBO selectBacklogForCard(@Param("workItemId") long workItemId);


    List<BacklogBO> selectBacklogListForCard(@Param("workitemIdList") List<Long> workitemIdList);

    /**
     * 将所有指定bpm_activity_id的待办项closed置为1
     *
     * @param bpmActivityIdList bpm_activity_id列表
     * @return 影响的行数
     */
    int updateClosedByBpmActivityIdList(@Param("bpmActivityIdList") List<Long> bpmActivityIdList);

    /**
     * 查询待办项状态
     *
     * @param backlogIdList 待办项id列表
     * @return 待办项状态信息
     */
    List<BacklogStateBO> selectBacklogState(@Param("backlogIdList") List<Long> backlogIdList);

    /**
     * 根据bpm_activity.id和bpmActivityId关闭待办项
     *
     * @param activityId
     * @param bpmActivityId
     * @return
     */
    @Update("update backlog \n" +
            "inner join bpm_activity_step on backlog.bpm_activity_step_id = bpm_activity_step.id \n" +
            "set backlog.closed=1 \n" +
            "where bpm_activity_step.activity_id= #{activityId} and bpm_activity_step.bpm_activity_id= #{bpmActivityId} ")
    int closeByBpmActivityId(@Param("activityId") Long activityId, @Param("bpmActivityId") String bpmActivityId);

    List<Backlog> selectByOriginalBacklogId(@Param("originalBacklogId") long originalBacklogId);

    /**
     * 根据流程主键关闭所有关联的待办（任务卡）
     *
     * @param bpmProcessSqlId
     * @return
     */
    int closeByBpmProcessSqlId(@Param("bpmProcessSqlId") long bpmProcessSqlId);

    /**
     * @param bpmProcessSqlId
     * @return
     */
    Backlog selectIdByWorkitemId(@Param("bpmProcessSqlId") long bpmProcessSqlId, @Param("workitemId") String workitemId);

    /**
     * 更新签核状态
     *
     * @param backlogId
     * @return
     */
    int updateApprovalState(@Param("backlogId") long backlogId, @Param("approvalState") String approvalState);

    List<Map> getDebuggerByWorkItemId(Long workitemId);

    /**
     * 根据bpmActivityId获取第一条未关闭的backlog
     *
     * @param bpmActivityId
     * @return
     */
    Backlog selectFirstUnClosedByBpmActivityId(@Param("bpmActivityId") long bpmActivityId);

    /**
     * 根据bpmActivity获取未关闭的backlog
     *
     * @param bpmActivityId
     * @return
     */
    List<Backlog> selectUnClosedByBpmActivityId(@Param("bpmActivityId") long bpmActivityId);

    /**
     * 获取待办的所属子项目Id
     *
     * @param backlogId
     * @return
     */
    Long getTaskId(@Param("backlogId") Long backlogId);

    List<Map> getChangeTaskDataSource(@Param("projectSqlId") Long projectSqlId, @Param("closed") Integer closed);

    /**
     * 根据项目ID和任务I，获取缓存的项目卡summaryLayout数据
     *
     * @param projectSqlId
     * @param tmActivityId
     * @return
     */
    Map getProjectSummaryLayout(@Param("projectSqlId") Long projectSqlId, @Param("tmActivityId") String tmActivityId);

    List<Map> getDesktopBacklogReport(@Param("tenantId") String tenantId, @Param("firstday") LocalDateTime firstday, @Param("lastDay") LocalDateTime lastDay, @Param("userIdList") List<String> userIdList);

    /**
     * 将待办项设置为未关闭，并跟胡源逾期待办项id
     *
     * @param id
     * @param overdueBacklogId
     */
    void updateUnclosedAndOverdueBacklogIdById(@Param("id") Long id, @Param("overdueBacklogId") Long overdueBacklogId);

    /**
     * 根据流程主键查询所有关联的待办（任务卡）
     *
     * @Author：SYQ
     * @Date：2021/6/16 17:34
     */
    List<String> selectByBpmProcessSqlId(@Param("bpmProcessSqlId") long bpmProcessSqlId);

    List<BacklogBO> selectInternalErrorByUserId(@Param("userId") String userId, @Param("tenantId") String tenantId);

    List<BacklogBO> selectInternalErrorByUserIdList(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId);

    Map getInternalErrorBacklogDetail(long backlogId);

    ActivityDataBO getInternalErrorActivityDataByBacklogId(long backlogId);

    List<Map> selectProcessingTaskByProjectId(@Param("projectSqlId") long projectSqlId);

    List<Map> getApiExecuteErrorBacklogDebuggerInfo(@Param("workItemId") long workItemId);

    Backlog selectOneByWorkItemId(@Param("workItemId") long workItemId);

    int batchCloseBacklog(@Param("dataList") List<Backlog> dataList);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<Backlog> entityList);

    /**
     * 根据项目卡id查询出对应的进行中的任务信息
     *
     * @param projectCardId 项目id信息
     * @param tenantId      租户id
     * @return list
     */
    List<Backlog> queryByProjectCardId(@Param("projectCardId") long projectCardId, @Param("tenantId") String tenantId);

    /**
     * 根据任务code分组计算行事历
     *
     * @Author：SYQ
     * @Date：2023/1/3 16:34
     */
    List<Map> groupCalendarByTmActivityId(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);

    /**
     * 根据执行人分组计算行事历
     *
     * @Author：SYQ
     * @Date：2023/1/3 16:34
     */
    List<Map> groupCalendarByPerformerId(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);

    /**
     * 根据分组查询行事历任务
     *
     * @Author：SYQ
     * @Date：2023/1/5 16:33
     */
    List<BacklogBO> selectCalendarByGroup(@Param("userIds") List<String> userIds, @Param("tenantId") String tenantId, @Param("nowTime") String nowTime,
                                          @Param("taskDefCode") String taskDefCode);

    /**
     * 根据查询条件查询行事历任务
     *
     * @Author：SYQ
     * @Date：2023/1/9 17:00
     */
    List<MobilePtmBacklogBO> selectCalendarByParam(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                                   @Param("queryParam") String queryParam);

    /**
     * 查询指定时间范围内的行事历任务列表（进行中的 + 已完成的）
     *
     * @param tenantId
     * @param userIds
     * @param beginTime
     * @param endTime
     * @return
     */
    List<BacklogBO> selectUserCalendarByTimeRange(@Param("tenantId") String tenantId, @Param("userIds") Set<String> userIds,
                                                  @Param("beginTime") String beginTime, @Param("endTime") String endTime);

    /**
     * 查询时间范围内的行事历任务
     *
     * @param userIds
     * @param tenantId
     * @param startTime
     * @param endTime
     * @return
     */
    List<BacklogBO> selectCalendarBacklogByTime(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId, @Param("nowTime") String nowTime,
                                                @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("completed") Boolean completed);

    /**
     * 查询时间范围内的非行事历任务
     *
     * @param userIdList
     * @param tenantId
     * @param startTime
     * @param endTime
     * @return
     */
    List<BacklogBO> selectNormalBacklogByTime(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId, @Param("nowTime") String nowTime,
                                              @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("completed") Boolean completed);

    /**
     * 团队行事历的行事历任务
     *
     * @param userIdList
     * @param tenantId
     * @param nowTime
     * @param startTime
     * @param endTime
     * @return
     */
    List<BacklogBO> selectTeamCalendarBacklog(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId, @Param("teamId") Long teamId,
                                              @Param("nowTime") String nowTime, @Param("startTime") String startTime,
                                              @Param("endTime") String endTime, @Param("completed") Boolean completed);

    /**
     * 团队行事历的普通任务
     *
     * @param userIdList
     * @param tenantId
     * @param nowTime
     * @param startTime
     * @param endTime
     * @return
     */
    List<BacklogBO> selectTeamNormalCalendarBacklog(@Param("userIdList") List<String> userIdList, @Param("tenantId") String tenantId, @Param("teamId") Long teamId,
                                                    @Param("nowTime") String nowTime, @Param("startTime") String startTime,
                                                    @Param("endTime") String endTime, @Param("completed") Boolean completed);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);

    /**
     * 查询时间范围内的行事历任务
     */
    Page<BacklogBO> selectCalendarBacklogByParam(Page<BacklogBO> page, @Param("req") CalendarQueryParamDTO calendarQueryParamDTO);

}
