package com.digiwin.athena.atmc.infrastructure.mapper.biz.migration;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogProjectBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmBacklog;
//import com.digiwin.athena.atmc.common.domain.ptm.PtmProjectCard;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.MobilePtmBacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmProjectCard;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public interface PtmBacklogMapper extends BaseMapper<PtmBacklog> {

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<PtmProjectCard> entityList);

    /**
     * 根据项目卡id 查找 不重复的 taskId 列表
     * @param projectCardId
     * @return taskId
     */
    List<PtmBacklog> selectTaskIdsByProjectCard(@Param("projectCardId") Long projectCardId);

    /**
     * 关闭待办。只更新 closed、closed_time、 和 modify_date
     * @param record
     * @return
     */
    Integer closeBacklog(@Param("record") PtmBacklog record);

    /**
     * 交接后，更改当责者
     * @param backlogIds
     * @param performerId
     * @param performerName
     * @return
     */
    Integer handoverPerformer(@Param("backlogIds") List<Long> backlogIds, @Param("performerId") String performerId, @Param("performerName") String performerName);

    /**
     * 已读次数增1
     * @param backlogId
     * @param modifyDate
     * @return
     */
    int increaseReadCount(@Param("backlogId") Long backlogId, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 设置是否加入我的最爱
     * @param backlogId
     * @param favorite 0-不加入，1-加入
     * @param modifyDate
     * @return
     */
    int updateFavorite(@Param("backlogId") Long backlogId, @Param("favorite") Integer favorite, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 更新提交记录
     * @param backlogId
     * @return
     */
    int updateSubmitId(@Param("backlogId") Long backlogId);

    /**
     * 获取进行中的待办最后更新时间
     * @param userId
     * @param tenantId
     * @return
     */
    LocalDateTime selectLastModifyDate(@Param("userId") String userId, @Param("tenantId") String tenantId);

    /**
     * 查询未完成的逾时任务
     * @param tenantId
     * @param userIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedOverdue(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);

    /**
     * 查询未完成任务
     * @param tenantId
     * @param backlogIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedPiningOverdue(@Param("tenantId") String tenantId, @Param("backlogIds") List<Long> backlogIds);

    /**
     * 查询所有逾时任务
     * @param tenantId
     * @param userIds
     * @return
     */
    List<PtmBacklogBO> selectAllOverdue(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                        @Param("startTime") String startPlanEndTime, @Param("endTime") String endPlanEndTime,
                                        @Param("backlogIdList") List<Long> backlogIdList, @Param("completed") Boolean completed);

    /**
     * 获取逾时任务卡
     * @param backlogId
     * @return
     */
    PtmBacklog selectOverdueById(@Param("backlogId") Long backlogId);

    /**
     * 关闭指定待办的逾时任务卡，如果有
     * @param backlogId
     * @param modifyDate
     * @return
     */
    int closeOverdueBacklog(@Param("backlogId") Long backlogId, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 根据workitemId和执行人，查找所有待办
     * @param workItemId
     */
    List<PtmBacklog> selectByWorkItemId(@Param("workItemId") Long workItemId);

    /**
     * 根据backlogId查找数据
     *
     * @Author：SYQ
     * @Date：2022/5/6 10:23
     */
    List<PtmBacklogBO> selectByBacklogIds(@Param("backlogIdList") List<Long> backlogIdList, @Param("minBack") Long minBack, @Param("maxBack") Long maxBack);

    /**
     * 查询未完成的数据一致性异常排除任务卡
     * @param tenantId
     * @param userIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedException(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);

    /**
     * 查询未完成的数据一致性异常排除任务卡
     * @param tenantId
     * @param backlogIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedPinningException(@Param("tenantId") String tenantId, @Param("backlogIds") List<Long> backlogIds);

    /**
     * 查询所有数据一致性异常排除任务卡
     * @param tenantId
     * @param userIds
     * @return
     */
    List<PtmBacklogBO> selectAllException(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                          @Param("startTime") String startPlanEndTime, @Param("endTime") String endPlanEndTime,
                                          @Param("backlogIdList") List<Long> backlogIdList, @Param("completed") Boolean completed);

    /**
     * 获取数据一致性异常排除任务卡
     * @param backlogId
     * @return
     */
    PtmBacklog selectDataUniformityById(@Param("backlogId") Long backlogId);


    /**
     * 根据任务code分组计算逾期任务
     * @Author：SYQ
     * @Date：2023/1/3 10:28
     */
    List<Map<String,Object>> groupCountByTaskDefCode(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);

    /**
     * 根据执行人分组计算逾期任务
     * @Author：SYQ
     * @Date：2023/1/3 10:28
     */
    List<Map<String,Object>> groupCountByPerformerId(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds);
    /**
     * 根据任务code查询未完成的逾期任务
     * @Author：SYQ
     * @Date：2023/1/6 15:24
     */
    List<PtmBacklogBO> selectOverdueByGroupParam(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                                 @Param("taskDefCode") String taskDefCode);
    /**
     * 根据任务code查询未完成的异常
     * @Author：SYQ
     * @Date：2023/1/6 15:24
     */
    List<PtmBacklogBO> selectExceptionByGroupParam(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                                   @Param("taskDefCode") String taskDefCode);

    /**
     * 查询未完成的逾时任务
     * @param tenantId
     * @param userIds
     * @return
     */
    List<MobilePtmBacklogBO> selectOverdueExceptionByParam(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                                           @Param("queryParam") String queryParam);

    /**
     * 查询指定用户列表、指定时间范围内的未完成的逾期任务
     *
     * @param tenantId  租户id
     * @param userIds   用户id列表
     * @param beginTime 起始的待办的计划完成时间
     * @param endTime   截止的待办的计划完成时间
     * @return
     */
    List<PtmBacklog> selectUserOverdueAndExceptionByTimeRange(@Param("tenantId") String tenantId, @Param("userIds") Collection<String> userIds,
                                                                 @Param("beginTime") String beginTime, @Param("endTime") String endTime);

    /**
     * 行事历任务
     * @param tenantId
     * @param userIds
     * @param teamId
     * @param startTime
     * @param endTime
     * @return
     */
    List<PtmBacklog> selectCalendarBacklog(@Param("tenantId") String tenantId, @Param("userIdList") Set<String> userIds, @Param("teamId") Long teamId,
                                           @Param("startTime") String startTime, @Param("endTime") String endTime,
                                           @Param("completed") Boolean completed);


    /**
     * 根据辅助执行人卡找到供应商卡
     */
    List<PtmBacklog> selectBacklogByTypeAndBacklogId(@Param("backlogIds") Collection<Long> backlogIds);


    /**
     * 批量查询submitids,每次最多5000
     *
     * @Author：jianglpc
     * @Date：2024/4/7 10:23
     */
    List<PtmBacklogBO> selectSubIdsBatByBackIds(@Param("backlogIdList") List<Long> backlogIdList);

    /**
     * 查询submitid
     *
     * @Author：jianglpc
     * @Date：2024/4/7 10:23
     */
    Integer selectSubIdBatByBackId(@Param("backlogId") Long backlogId);

    /**
     * 查询未完成的逾时任务
     * @param tenantId
     * @param backlogIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedOverdueByBacklogId(@Param("tenantId") String tenantId, @Param("backlogIds") List<String> backlogIds);

    /**
     * 查询未完成的数据一致性异常排除任务卡
     * @param tenantId
     * @param backlogIds
     * @return
     */
    List<PtmBacklogBO> selectNoFinishedExceptionByBacklogId(@Param("tenantId") String tenantId, @Param("backlogIds") List<String> backlogIds);

    /**
     * 更新待办动作id
     * @param backlogId
     * @param actionId
     * @param modifyDate
     * @return
     */
    int updateBacklogActionIdByBacklogId(@Param("backlogId") Long backlogId, @Param("actionId") String actionId, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 通过项目卡id查询待办返回指定字段
     * @param projectCardIds
     * @return
     */
    List<PtmBacklogProjectBO> selectBacklogByProjectCardId (@Param("projectCardIds") List<Long> projectCardIds);

}
