package com.digiwin.athena.atmc.infrastructure.pojo.bo.migration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ActivityDataBO {

    private Long taskId;
    private String tmTaskId;
    private String tmActivityId;
    private String tenantId;
    /**
     * bpm_activity.id
     */
    private Long bpmActivitySqlId;

    /**
     * bpm_activity.data,JSONObject
     */
    private String bpmData;
    /**
     * bpm_activity.data,JSONObject
     */
    private String bpmStateData;
    /**
     * bpm_activity.bpmn_type
     */
    private String bpmActivityType;

    /**
     * bpm_activity_step.bpm_activity_id
     * BPM中的关卡ID
     */
    private String bpmActivityId;

    /**
     * bpm_activity.performer_id,JSONArray
     */
    private String performerIds;

    /**
     * bpm_activity.process_serial_number
     */
    private String processSerialNumber;

    /**
     * activity_define.tm_activity_name
     */
    private String tmActivityName;

    private String tmPattern;

    private  String tmCategory;

    /**
     * backlog.id
     * <p>PTM对应的是ptm_backlog.id</p>
     */
    private Long backlogId;

    private Integer submitId;

    private String backlogName;

    /**
     * 执行者的租户id
     */
    private String targetTenantId;
    /**
     * bpm_activity_workitem.performer_id
     */
    private String performerId;

    /**
     * 人员状态true在职，false离职
     */
    private Boolean performerState;

    /**
     * bpm_activity_workitem.performer_name
     */
    private String performerName;

    // 代理人ID -- 被谁代理
    private String performerAgentId;

    private String performerAgentName;



    /**
     * backlog.read_count
     */
    private Integer readCount;

    /**
     * 实际开始时间
     * backlog.start_time
     */
    private LocalDateTime startTime;

    /**
     * 计划完成时间
     * backlog.end_time
     */
    private LocalDateTime planEndTime;

    /**
     * 实际结束时间
     * bpm_activity.closed_time
     */
    private LocalDateTime endTime;

    /**
     * bpm_activity_step.workitem_list,JSONArray
     */
    private String workitemList;

    /**
     * bpm_activity_workitem.action_id
     */
    private String finishedActionId;

    /**
     * task.person_in_charge
     */
    private String chargeId;

    /**
     * task.person_in_charge_name
     */
    private String chargeName;


    private String businessUnit;

    private String eocName;

    /**
     * task.start_time
     */
    private LocalDateTime taskStartTime;

    /**
     * task.end_time
     */
    private LocalDateTime taskEndTime;

    /**
     * 流程的发起时间，bpm_process.create_time
     */
    private LocalDateTime processCreateTime;

    /**
     * task.name
     */
    private String taskName;

    /**
     * activity_define.tm_show_flow
     */
    private Boolean tmShowFlow;

    /**
     * bpm_activity_step.id
     */
    private Long stepId;

    /**
     * 来源单号
     * task.source_ids
     */
    private String taskSourceIds;

    /**
     * 签核原因
     * bpm_activity_step.bpm_sign_reason
     */
    private String stepSignReason;

    /**
     * 签核状态，backlog.approval_state
     */
    private String approvalState;

    /**
     * 待办项 状态
     */
    private Boolean backlogClosed;

    /**
     * 是否合并的任务
     */
    private Boolean merge;

    /**
     * 流程的代理 token
     */
    private String proxyToken;

    /**
     * 动态任务的id,参与项目卡合并计算
     */
    private String compositionId;

    /**
     * 发生逾期的 workitem.Id
     */
    private Long overdueWorkitemId;

    /**
     * bpm_activity_workitem.id
     * <p>PTM对应的是ptm_workitem.id</p>
     */
    private Long workItemId;
    /**
     * ptm_task_workitem中的activityId
     */
    private Long ptmActivityId;

    private Integer createType;

    private String comment;

    private Integer state;

    private Integer subState;

    //代理人ID
    private String agentPerformerId;
    private String agentPerformerName;

    //是否代理人执行，0-非代理人，1-代理人，2-辅助执行得
    private Integer performerType = 0;

    /**
     * 前置任务uid
     */
    @JsonIgnore
    private String preTaskUid;

    /**
     * 前置任务的所有者id
     */
    private String prePerformerId;

    /**
     * 前置任务所有者名称
     */
    private String  prePerformerName;
    //如果提交的是代理人或者辅助者执行者，则记录
    private String preAgentPerformerId;
    private String  preAgentPerformerName;
    /**
     * 如果是1，是代理人执行，是2，辅助执行者执行
     */
    private Integer prePerformerType;

    /**
     * bpm_activity_step.state
     */
    private Integer stepState;

    /**
     * bpm_activity_step.sub_state
     */
    private Integer stepSubState;

    /**
     * 调用链ID
     */
    private String traceId;

    private String taskUid;

    /**
     * 项目来源：PTM表示来源于PTM，其他表示ATMC
     * <p>参考：BpmConstant.DATA_FROM_PTM</p>
     */
    private String dataFrom;

    private Long ptmBacklogId;
    private Long ptmWorkItemId;

    /**
     * 关联任务卡
     */
    private Long sourceWorkitemId;
    /**
     * 任务卡类型
     */
    private Integer type;

    private String bpmWorkItemId;

    private Long groupId;

    private LocalDateTime planEndTimeMin;

    private LocalDateTime planEndTimeMax;
    /**
     * 项目的流程变量
     */
    private String projectBpmData;

    /**
     * 待办的执行人
     * 为了兼容辅助执行人，待办的执行人和workItem的执行人不同的情况
     */
    private String backlogPerformId;

    /**
     * 项目卡id
     */
    private Long projectCardId;

    /**
     * 项目卡状态
     */
    private Integer projectCardState;

    /**
     * 项目状态
     */
    private Integer projectState;

}
