package com.digiwin.athena.atmc.infrastructure.pojo.bo.migration;

import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.atmc.core.meta.constants.BpmConstant;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BacklogBO {
    private Long id;
    @LanguageMark
    private String name;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String withName;

    /**
     * 任务(activity)子名称
     */
    @LanguageMark
    private String subName;

    @LanguageMark
    private String taskName;
    @LanguageMark
    private String taskTargetName;

    /**
     * 项目开始时间
     */
    private LocalDateTime taskStartTime;

    /**
     * 项目截止时间
     */
    private LocalDateTime taskEndTime;
    private boolean taskImportance;

    /**
     * bpm_activity_workitem.importance
     */
    private boolean importance;
    @LanguageMark
    private String content;
    private boolean importanceReadOnly;

    /**
     * bpm_activity_workitem.importance_source
     */
    private String importanceSource;
    private String uri;

    /**
     * 任务实际开始时间
     */
    private LocalDateTime startTime;

    /**
     * 任务计划完成时间
     */
    private LocalDateTime endTime;

    private String tmTaskId;
    private String tmActivityId;
    private Integer type;
    private String tenantId;
    private String targetTenantId;

    private boolean actionDefined;

    private Long bpmActivityId;
    private String tmPattern;
    private String tmCategory;

    private List<Map<String, Object>> checkItems;
    private String operation;
    private Map<String, Object> summaryLayout;
    private String summaryLayoutStr;
    private Map<String, Object> error;
    private Boolean isOwner;
    private String performerId;
    private String performerName;
    private String ownerUserId;

    private String ownerUserName;

    /**
     * 代理人id  被谁代理
     */
    private String ownerAgentUserId;

    /**
     * 代理人名称  被谁代理
     */
    private String ownerAgentUserName;

    /**
     * 人员状态true启用false停用
     */
    private Boolean performerState;

    /**
     * 已读次数
     */
    private Integer readCount;

    /**
     * 是否异常;activity.exception
     */
    private Boolean exception;

    /**
     * 是否逾期
     */
    private Boolean overdue;

    /**
     * 逾期总分钟
     */
    private Integer overdueMinutes;

    /**
     * 逾期总小时数
     */
    private Integer overdueHours;

    /**
     * 逾期总天数
     */
    private Integer overdueDays;

    /**
     * 转派的来源backlog.id，不为0表示转派
     */
    private Long reassignFromId;

    /**
     * 签核状态
     */
    @LanguageMark
    private String approvalState;

    /**
     * 待办数量列表，例如 待处理XX项
     */
    private List<Map<String, Object>> todoItems;

    /**
     * 项目最后一次修改时间
     */
    private LocalDateTime modifyDate;

    /**
     * 是否紧急
     */
    private boolean emergency;

    /**
     * 营运单元code，由公司id、工厂id等单元拼接而成
     */
    private String eocCode;

    /**
     * 营运单元name，由公司名称、工厂名称等单元拼接而成
     */
    private String eocName;

    /**
     * 营运单元最小指示维度，如：公司：1，工厂：2
     */
    private Integer eocType;

    /**
     * 缓存的summaryLayout
     */
    private String summaryLayoutCacheText;

    private String processSerialNumber;

    /**
     * 代理开始日期
     */
    private String agentBeginDate;

    /**
     * 代理截止日期
     */
    private String agentEndDate;

    /**
     * 发生逾期的 workitem.Id
     */
    private Long overdueWorkitemId;
    /**
     * 来源租户名称
     */
    private String sourceTenantName;

    /**
     * bpm_activity_workitem.id
     */
    private Long workItemId;

    /**
     * 代理token
     */
    private String proxyToken;
    /**
     * 历史资讯
     */
    private String historyMessage;

    private String finishActionId;

    /**
     * themeMap定义的名称
     */
    @LanguageMark
    private String tmActivityName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String tmActivityWithName;

    /**
     * 任务卡来源：PTM表示来源于PTM，其他表示ATMC
     * <p>参考：BpmConstant.DATA_FROM_PTM</p>
     */
    private String dataFrom;

    @JsonIgnore
    public Boolean isPtm(){
        return BpmConstant.DATA_FROM_PTM.equals(dataFrom);
    }

    /**
     * 任务卡摘要
     */
    private String summary;
    /**
     * 搜索项
     */
    private String searchMessage;
    /**
     * 来源任务
     */
    private String sourceWorkitemId;

    private String bpmData;

    /**
     * 是否合并的任务
     */
    private Boolean merge;

    private LocalDateTime planEndTimeMin;

    private LocalDateTime planEndTimeMax;

    /**
     * 任务变更数据是否被已读
     */
    private Integer dataChangeRead;

    /**
     * 是否是行事历任务
     */
    private Boolean calendar;

    private Long groupId;

    /**
     * 状态
     */
    private Integer state;

    private String approvalStateCode;

    /**
     * 引擎类型，参考枚举类型 BpmEngineCategory。<br>
     * null也表示流程引擎
     */
    private String engineType;

    /**
     * 提交唯一标识
     */
    private Integer submitId;

    /**
     * 实际完成时间
     */
    private LocalDateTime closedTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 是否有应用授权
     */
    private Boolean hasAppPermission;
    /**
     * 被辅助租户
     */
    private String auxiliaryTenantId;
    /**
     * 被辅助租户名称
     */
    private String auxiliaryTenantName;

    /**
     * 是否分享卡片
     */
    private Boolean pinning;

    /**
     * 自定义分组
     */
    private Map<String, String> group;

    /**
     * 自定义标签
     */
    private List<Map<String, Object>> labels;

    /**
     * 自定义排序
     */
    private Map<String, String> order;

    /**
     * 自定义列
     */
    private List<Map<String, String>> columns;

    /**
     * 引擎中是否有待处理  add by 6203
     */
    private Boolean engineHasWaittingData;
    /**
     *来源处理者id
     */
    private String oldPerformerId;
    /**
     *来源处理者姓名
     */
    private String oldPerformerName;
}
