package com.digiwin.athena.atmc.infrastructure.pojo.bo.migration;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author：SYQ
 * @date：2023/1/9
 */
@Data
public class MobilePtmBacklogBO {
    /**
     * 任务、待办的id
     */
    private Long backlogId;
    /**
     * 任务、待办的名称
     */
    private String taskName;
    /**
     * 任务、待办的类型，同任务列表
     * 1-普通任务
     * 11-辅助执行者任务
     * 88-逾时任务卡
     * 72-行事历任务
     * 89-数据一致性异常排除任务
     */
    private Integer type;
    /**
     * 执行人
     */
    private String performerId;
    /**
     * 任务的预计完成时间
     */
    private LocalDateTime planEndTime;
    /**
     * 所属项目卡名称，有自定义名称优先使用自定义名称
     */
    private String projectName;
    /**
     * 项目卡时距开始时间
     */
    private LocalDateTime projectStartTime;
    /**
     * 项目卡时距结束时间
     */
    private LocalDateTime projectEndTime;
}
