package com.digiwin.athena.atmc.infrastructure.pojo.bo.migration;

import com.digiwin.athena.appcore.domain.LanguageMark;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 项目详情数据(project表记录)
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectRecordBO {

    private Long id;
    private Long projectCardId;
    private String projectDefCode;
    private String projectDefName;
    private String projectDefPattern;
    private String sourceEntityName;
    private String projectName;
    private String processSerialNumber;
    private Integer state;
    private Integer subState;
    private String personInCharge;
    private String personInChargeName;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Map mergeData;
    private String sourceIds;
    private String sourceName;
    private String remark;
    private Boolean hidden;
    private Boolean changedFlag;
    private Boolean completedReport;
    private String eocCode;
    private String eocName;
    private Integer eocType;
    private JSONObject businessUnit;
    private LocalDateTime dueDate;
    private String dueDateName;
    /**
     * 紧急度，25（紧急），50（一般-默认），75（低）
     */
    private Integer emergency;
    private String proxyToken;
    private LocalDateTime createTime;
    private String closedTime;
    private String engine;
    private String traceId;
    private Boolean importance;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;
    private Map data;
    private Boolean expire;

}
