package com.digiwin.athena.atmc.infrastructure.pojo.bo.migration;

import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PTM 任务详情数据(task表记录)
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmTaskRecordBO {

    private Long id;
    private Long projectId;
    private Long projectCardId;

    private String taskName;
    private String taskType;
    private LocalDateTime planEndTime;
    private String signReason;
    private String taskDefCode;
    private String taskDefName;
    private String taskDefPattern;
    private String taskDefCategory;
    private String taskDefExecuteType;
    private Boolean milestone;
    private Integer state;
    private Integer subState;
    private String processSerialNumber;
    private String bpmnType;
    private String bpmTaskUid;
    private String bpmSourceTaskUid;
    private String engine;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Map businessUnit;
    private String proxyToken;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;
    private Map data;

    /**
     * 任务是否有异常
     * @return
     */
    public Boolean getHasException(){
        return Objects.equals(this.taskDefPattern, TmTaskPatternEnum.BUSINESS.getValue()) && Objects.equals(this.taskDefCategory, TmTaskCategoryEnum.SOLVE.getValue());
    }
}
