package com.digiwin.athena.atmc.infrastructure.pojo.po.migration;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import com.digiwin.athena.atmc.infrastructure.utils.MySqlJsonArrayHandler;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONArray;

import java.time.LocalDateTime;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BpmActivityWorkitem {

    @TableId()
    private Long id;

    private Long activityStepId;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;

    private String performerId;
    private String performerName;

    /**
     * 人员状态true在职，false离职
     */
    @TableField(exist = false)
    private Boolean performerState;

    private String workitemId;

    private String comment;

    private Integer state;

    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray reassign;

    private LocalDateTime rowCreateTime;
    private LocalDateTime rowMoidfyTime;

    //代理人ID --代理的谁
    private String agentPerformerId;
    private String agentPerformerName;

    // 代理人ID -- 被谁代理
    @TableField(exist = false)
    private String performerAgentId;
    @TableField(exist = false)
    private String performerAgentName;

    //是否代理人执行，0-非代理人，1-代理人，2-辅助执行得
    private Integer performerType = 0;

    /**
     * 已读次数
     */
    private Integer readCount = 0;

    /**
     * 该步骤执行的actionId
     */
    private String actionId;


    /**
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 30	其他處理者已處理完成
     * 50	往前加簽而關閉
     * 60	退回重簽而關閉
     * 70	取回重辦而關閉
     * 80	由第三方強制終止項目而關閉
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 110	因轉派而關閉
     * 120	因他人執行退回重簽而關閉
     * 130	因其他人執行往前加簽而關閉
     * 140	往後加簽而關閉
     * 150	因退回重辦而關閉
     * 160	因其他人執行退回重辦而關閉
     */
    private Integer subState;

    /**
     * 原逾期的workitem.Id
     */
    private Long overdueWorkitemId = 0L;

    /**
     * 类型，类型，1-普通，BPM的；11-辅助执行人的，88-逾时追踪，89-数据一致性异常排除
     */
    private Integer type = 1;

    /**
     * 取值 0=正常产生/1=转派/2=退回重签/3=退回重办/4=加签
     */
    private Integer createType = 0;

    /**
     * 特殊操作状态,空-无状态，reassign-转派,reexecute-退回重办,add-task-加签，abort-task-撤回，reapproval-退回重签
     */
    private String approvalState = "";

    /**
     * 1=转派/2=退回重签/4=加签等任务的来源任务workitemId
     */
    private String fromWorkitemId;

    /**
     * 任务合并后，所属分组ID
     * 值为 0 表示未合并
     */
    private Long groupId = 0L;

    /**
     * 目标租户，该工作项给哪个租户操作查看的
     * 该工作荐真正属于哪个租户，可以查看 bpmActivityStep.tenatnId
     */
    private String targetTenantId;

    /**
     * 重要性，我的最爱
     */
    private Integer importance;

    /**
     * 重要性的来源，如果来源是Athena，不能修改
     */
    private String importanceSource;

    /**
     * 协作厂商、企业用户的执行人ID
     */
    private String commonPerformerId;

    /**
     * 来源任务
     */
    private Long sourceWorkitemId;

    /**
     * 是否是合并任务里的主任务
     */
    @TableField(exist = false)
    private Boolean mainWorkitem;

}
