package com.digiwin.athena.atmc.infrastructure.pojo.po.migration;

import lombok.*;

import java.util.List;

/**
 * 行事历查询参数封装
 *
 * @author gengwei
 * @since 2024/9/26 17:44
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CalendarQueryParamDTO {

    /**
     * 计划时间(开始时间)
     */
    private String startTime;

    /**
     * 计划时间(结束时间)
     */
    private String endTime;

    /**
     * 需要查询的行事历的任务的状态 false: 進行中/暫停 , true:已完成
     */
    private Boolean completed;

    /**
     * 搜索关键词
     */
    private String searchKey;

    /**
     * 当前时间
     */
    private String nowTime;

    /**
     * 用户id
     */
    private List<String> userIdList;

    /**
     * 租户ID
     */
    private String tenantId;
}
