package com.digiwin.athena.atmc.infrastructure.pojo.po.migration;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
//import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * PTM待办
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class PtmBacklog extends BaseEntity<PtmBacklog> {
    @TableId()
    private Long backlogId;

    /**
     * 待办所属租户
     */
    private String tenantId;
    private String tenantName;

    /**
     * 待办的目标租户，给哪个租户的
     */
    private String targetTenantId;

    private Long projectCardId;
    private Long projectId;
    private Long taskId;
    private Long activityId;
    private Long workItemId;
    private String performerId;
    private String performerName;
    private Boolean closed = false;
    private LocalDateTime planEndTime;

    private String taskDefCode;
    private String taskDefName;
    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    @TableField(exist = false)
    private String taskDefWithName;

    private String taskName;
    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    @TableField(exist = false)
    private String taskWithName;

    private LocalDateTime createTime;
    private LocalDateTime closedTime;

    /**
     * 已读次数
     */
    private Integer readCount = 0;

    /**
     * 我的最爱
     */
    private Integer favorite = 0;

    /**
     * 该步骤执行的actionId
     */
    private String actionId;

    /**
     * 提交唯一标识
     */
    private Integer submitId;

    /**
     * 特殊操作状态,空-无状态，reassign-转派,reexecute-退回重办,add-task-加签，abort-task-撤回，reapproval-退回重签
     */
    private String approvalState = "";

    /**
     * 原逾期的backlogId
     */
    private Long overdueBacklogId;

    /**
//     * 处理者类型0:默认;1:辅助执行者;2:跨租户;88-逾时追踪;89-数据一致性异常排除
     */
    private Integer type;

    /**
     * 是否合并的
     */
    private Boolean merge;

    /**
     * 来源任务卡
     */
    private Long sourceBacklogId;

    /**
     * 任务卡是否隐藏   0 不隐藏，1 隐藏
     */
    private Integer hide;

    /**
     * 营运单元code，由公司id、工厂id等单元拼接而成
     * 例如:walrus-001
     * 合并任务(eoc是合并条件之一）、非合并任务，因为backlog.business_unit是取自task.business_unit，所以理论上两者值都应该相同
     */
    @TableField(exist = false)
    private String eocCode;

    /**
     * 营运单元name，由公司名称、工厂名称等单元拼接而成
     * 例如:大井-總公司
     * 合并任务(eoc是合并条件之一）、非合并任务，因为backlog.business_unit是取自task.business_unit，所以理论上两者值都应该相同
     */
    @TableField(exist = false)
    private String eocName;

    /**
     * 营运单元最小指示维度
     * 例如：公司：1，工厂：2
     * 合并任务(eoc是合并条件之一）、非合并任务，因为backlog.business_unit是取自task.business_unit，所以理论上两者值都应该相同
     */
    @TableField(exist = false)
    private Integer eocType;
}
