package com.digiwin.athena.atmc.infrastructure.pojo.po.migration;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
//import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * PTM项目卡
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class PtmProjectCard extends BaseEntity<PtmProjectCard> {

    private Long id;

    private Integer submitId;

    private String projectCode;

    private String projectName;

    private String tenantId;

    private String tenantName;

    private String personInCharge;
    private String personInChargeName;

    private LocalDateTime startTime;
    private LocalDateTime endTime;

    /**
     * 项目卡关闭的时间
     */
    private LocalDateTime closedTime;

    private Boolean completedReport;

    /**
     * 進行中1
     * 暫停2
     * 順利完成的3
     */
    private Integer state;

    /**
     * 已读次数，目前仅适用于主项目
     */
    private Integer readCount = 0;

    /**
     * 我的最爱
     */
    private Integer favorite;

    /**
     * 引擎类型，此表应该永远为 TaskEngine
     * FlowEngine 流程引擎
     * TaskEngine 任务引擎
     */
    private String engineType;

    private String targetId;
    private String targetName;

    @TableField(exist = false)
    private String summary;
    @TableField(exist = false)
    private String historyMessage;
    @TableField(exist = false)
    private String searchMessage;

    /**
     * 增加PTM项目卡的自定义名称
     */
    private String name;

    /**
     * 项目卡是否隐藏   0 不隐藏，1 隐藏
     */
    private Integer hide;
}
