package com.digiwin.athena.atmc.infrastructure.redis.cache;

import java.time.Duration;

public interface CacheQService {

    /**
     * 判断是否存在
     */
    boolean hasKey(String key);

    /**
     * 判断是否存在
     */
    boolean hasKey(String serviceName,String functionName,String paraStr);

    /**
     * 删除
     */
    void delete(String key);

    /***
     * 缓存
     */
    void cache(String key,String value);

    /***
     * 缓存
     */
    void cache(String key, String value, Duration duration);

    /***
     * 缓存
     */
    void cache(String serviceName,String functionName,String paraStr, String value);

    /***
     * 缓存
     */
    void cache(String serviceName, String functionName, String paraStr, String value, Duration duration);

    /**
     * 获取缓存
     */
    Object get(String key);

    /**
     * 获取缓存
     */
    Object get(String serviceName,String functionName,String paraStr);

    /**
     * 批量删除
     */
    void batchDelete(String pattern);

    /**
     * 无前缀缓存
     */
    void cacheNoPrefix(String key,String value);

}
