/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.presentation.server.web.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.BacklogAsyncConfig;
import com.digiwin.athena.atmc.application.dto.request.TodoBackLogNumReq;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.query.backlog.BpmTodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.application.service.query.backlog.TodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.core.meta.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.atmc.presentation.common.controller.BaseController;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atmc/v1/backlog"})
public class BacklogQueryController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BacklogQueryController.class);
    @Autowired
    private BpmTodoBacklogQueryCountingQryService bpmTodoBacklogServiceQuery;
    @Autowired
    private TodoBacklogQueryCountingQryService backlogCardQueryService;
    @Autowired
    BacklogAsyncConfig backlogAsyncConfig;
    @Autowired
    DynamicThreadPool taskExecutor;

    public CompletableFuture<Void> submit(Runnable task) {
        return CompletableFuture.runAsync(task, (Executor)this.taskExecutor);
    }

    @GetMapping(value={"/list/size"})
    List<TaskCardResp> getBacklogList(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody @Validated TodoBackLogNumReq req) {
        log.info("[backlogList-{}-{}-{}-{}]", new Object[]{user.getUserId(), user.getTenantId(), req.getClientType(), req.getClientId()});
        ArrayList<TaskCardResp> backlogDTOS = new ArrayList<TaskCardResp>();
        Runnable bpmTask = () -> backlogDTOS.addAll(this.bpmTodoBacklogServiceQuery.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> bpmSubmit = this.submit(bpmTask);
        Runnable ptmTask = () -> backlogDTOS.addAll(this.backlogCardQueryService.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> ptmSubmit = this.submit(ptmTask);
        try {
            CompletableFuture.allOf(bpmSubmit, ptmSubmit).get(this.backlogAsyncConfig.getTimeOut(), this.backlogAsyncConfig.getTimeUnit());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return backlogDTOS;
    }
}

