/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.presentation.common.advice;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice(basePackages={"com.digiwin.athena.atmc.presentation.server.web"})
public class ResponseDtoAdvice
implements ResponseBodyAdvice<Object>,
InitializingBean {
    private String[] excludedClassNames;
    private static final String[] DEFAULT_EXCLUDED_CLASS_NAMES = new String[]{BaseResultDTO.class.getName()};

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        return AbstractJackson2HttpMessageConverter.class.isAssignableFrom(converterType);
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        MappingJacksonValue container = this.getOrCreateContainer(body);
        this.beforeBodyWriteInternal(container);
        return container;
    }

    protected void beforeBodyWriteInternal(MappingJacksonValue bodyContainer) {
        Object value = bodyContainer.getValue();
        if (!this.isExcludedValue(value)) {
            BaseResultDTO result = new BaseResultDTO();
            result.setStatus(Integer.valueOf(HttpStatus.OK.value()));
            result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
            if (value != null) {
                result.setResponse(value);
            }
            bodyContainer.setValue((Object)result);
        }
    }

    private boolean isExcludedValue(Object value) {
        return value != null && this.isExcludedClass(value.getClass());
    }

    private boolean isExcludedClass(Class<?> clazz) {
        for (String excludedClassName : this.excludedClassNames) {
            if (!Objects.equals(excludedClassName, clazz.getName())) continue;
            return true;
        }
        return false;
    }

    protected MappingJacksonValue getOrCreateContainer(Object body) {
        return body instanceof MappingJacksonValue ? (MappingJacksonValue)body : new MappingJacksonValue(body);
    }

    public void afterPropertiesSet() {
        this.excludedClassNames = this.excludedClassNames == null ? DEFAULT_EXCLUDED_CLASS_NAMES : (String[])ArrayUtils.addAll((Object[])this.excludedClassNames, (Object[])DEFAULT_EXCLUDED_CLASS_NAMES);
    }
}

