package com.digiwin.athena.cdme.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * rabbitmq 属性配置信息，后续删除xml配置时需放开注释
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/6/15
 */
@Configuration
public class CdmeRabbitMQProp {

    @Value("${spring.rabbitmq.cdme.listener.simple.concurrency:5}")
    private int simpleConcurrency;

    @Value("${spring.rabbitmq.cdme.listener.simple.max-concurrency:10}")
    private int simpleMaxConcurrency;

    @Value("${spring.rabbitmq.cdme.listener.simple.prefetch:1}")
    private int simplePrefetch;

    @Value("${spring.rabbitmq.cdme.listener.simple.retry.initial-interval:1000}")
    private int simpleInitialInterval;

    @Value("${spring.rabbitmq.cdme.listener.simple.retry.max-interval:10000}")
    private int simpleMaxInterval;

    @Value("${spring.rabbitmq.cdme.listener.simple.retry.multiplier:2}")
    private int simpleMultiplier;

    public int getSimpleConcurrency() {
        return simpleConcurrency;
    }

    public int getSimpleMaxConcurrency() {
        return simpleMaxConcurrency;
    }

    public int getSimplePrefetch() {
        return simplePrefetch;
    }

    public int getSimpleInitialInterval() {
        return simpleInitialInterval;
    }

    public int getSimpleMaxInterval() {
        return simpleMaxInterval;
    }

    public int getSimpleMultiplier() {
        return simpleMultiplier;
    }
}
