package com.digiwin.athena.cdme.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description
 * @date 2024/7/5 19:15
 * @Copyright 鼎捷软件股份有限公司
 */
@Configuration
public class CdmeThreadPoolConfig {
    @Bean(name = "cdmeMsgExecutor")
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(4); // 核心线程数
        executor.setMaxPoolSize(8); // 最大线程数
        executor.setQueueCapacity(8192); // 队列容量
        executor.setKeepAliveSeconds(120); // 线程空闲时间（秒）
        executor.setThreadNamePrefix("MqttExecutor-"); // 线程名前缀
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy()); // 拒绝策略
        executor.initialize(); // 初始化
        return executor;
    }
}