package com.digiwin.athena.cdme.core.enums;

/**
 * @description: 运维接口返回信息
 * @author: renwm
 * @date: 2020/5/9 9:09
 */
public enum MonitorOpsActionStatusEnum {

    /** 流程状态信息 start*/
    /*发流程: 第一位：去重后是否还有数据，第二位：是否继续发起流程(取自于规则定义中的isGoOn值)， 第三位：是否流程成功 */
    ACTION_STATUS_000("000", "去重后没有数据，定义为无数据不发流程，不发起流程"),
    ACTION_STATUS_010("010", "去重后没有数据，定义为无数据仍发起流程，发起流程失败"),
    ACTION_STATUS_011("011", "去重后没有数据，定义为无数据仍发起流程，发起流程成功"),
    ACTION_STATUS_100("100", "去重后有数据，定义为无数据不发流程，发起流程失败"),
    ACTION_STATUS_101("101", "去重后有数据，定义为无数据不发流程，发起流程成功"),
    ACTION_STATUS_110("110", "去重后有数据，定义为无数据仍发起流程，发起流程失败"),
    ACTION_STATUS_111("111", "去重后有数据，定义为无数据仍发起流程，发起流程成功");
    /** 流程状态信息 end*/

    private final String type;
    private final String desc;

    MonitorOpsActionStatusEnum(String type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    public static String getEnumByType(String type) {
        for (MonitorOpsActionStatusEnum itemEnum : MonitorOpsActionStatusEnum.values()) {
            if (itemEnum.getType().equals(type)) {
                return itemEnum.getDesc();
            }
        }
        return "";
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
