package com.digiwin.athena.cdme.repository.model;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;

import java.time.LocalDateTime;

/**
 * @description: 侦测规则实体类
 * @author: renwm
 * @date: 2020/4/28 13:48
 */
@TableName("sd_monitor_rule")
public class MonitorRuleModel {
    /** 主键ID */
    @TableId(type = IdType.AUTO)
    private Long kid;
    /** 规则ID */
    private String ruleId;
    /** 租户ID */
    private String tenantId;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;
    /** eoc区域ID */
    private String eocRegionId;
    /** 执行服务类型 */
    private String actionType;
    /** 执行服务ID */
    private String actionId;
    /** 侦测规则ID */
    private String monitorActionId;
    /** 侦测类型 SCAN:扫描侦测 API:API侦测 */
    private String category;
    /** 侦测规则json字符串  */
    private String monitorRule;
    /** 分组ID */
    private String triggerId;
    /** 地端erp产品名称 */
    private String productName;
    /** 创建时间 */
    private LocalDateTime createTime;
    /** 更新时间 */
    private LocalDateTime updateTime;
    /** 是否可用,Y:可用,N:不可用,已删除 */
    private String isEnable;
    /** 侦测类型 */
    private String monitorType;
    /** 分页下发执行的侦测数量 */
    private Integer pageSize;

    public MonitorRuleModel() {
        this.isEnable = FieldValConstant.RULE_ENABLE;
    }

    public MonitorRuleModel(String ruleId, String tenantId, String productName) {
        this.ruleId = ruleId;
        this.tenantId = tenantId;
        this.productName = productName;
    }

    public MonitorRuleModel(JSONObject ruleObj) {
        this.isEnable = "Y";
        this.ruleId = ruleObj.getString(FieldConstant.RULE_ID);
        this.tenantId = ruleObj.getString(FieldConstant.TENANT_ID);
        this.actionId = ruleObj.getString(FieldConstant.ACTION_ID);
        this.actionType = ruleObj.getString(FieldConstant.ACTION_TYPE);
        this.productName = ruleObj.getString(FieldConstant.PRODUCT_NAME);
        this.category = ruleObj.getString(FieldConstant.CATEGORY);
        this.monitorType = ruleObj.getString(FieldConstant.MONITOR_TYPE);
        this.monitorActionId = ruleObj.getString(FieldConstant.MONITOR_ACTION_ID);
        this.pageSize = ruleObj.getInteger(FieldConstant.EXECUTE_PAGE_SIZE);

    }

    public Long getKid() {
        return kid;
    }

    public void setKid(Long kid) {
        this.kid = kid;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getEocRegionId() {
        return eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    public String getMonitorRule() {
        return monitorRule;
    }

    public void setMonitorRule(String monitorRule) {
        this.monitorRule = monitorRule;
    }

    public String getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
    }

    public String getMonitorActionId() {
        return monitorActionId;
    }

    public void setMonitorActionId(String monitorActionId) {
        this.monitorActionId = monitorActionId;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getMonitorType() {
        return monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
