package com.digiwin.athena.cdme.service.facade.detection;

import com.digiwin.athena.cdme.pojo.bo.EocTimeRangeBO;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 13:17
 */
public interface IDetectionTimeRangeService {

    /**
     * 获取侦测时间区间
     * @param triggerModel
     * @param needOffset
     * @param eocList
     * @return
     */
    List<EocTimeRangeBO> getTimeRange(MonitorTriggerModel triggerModel, boolean needOffset,
        List<EocDto> eocList);

    /**
     * 滑动时间窗口
     * @param timeRangeBO
     * @return
     */
    ResultDto<Void> moveTimeRange(EocTimeRangeBO timeRangeBO);

}
