package com.digiwin.athena.cdme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * JSON处理工具类
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/07/17
 */
public final class JsonUtil {
    private JsonUtil() {
    }

    /**
     * json串转换成对象
     *
     * @param jsonText
     * @param clazz
     * @return T
     */
    public static <T> T getObject(String jsonText, Class<T> clazz) {
        return JSON.parseObject(jsonText, clazz);
    }

    /**
     * json串转换成对象
     *
     * @param jsonText
     * @return T
     */
    public static JSONObject getObject(String jsonText) {
        return JSON.parseObject(jsonText);
    }

    public static <T> T parseObject(String text, TypeReference<T> type) {
        return JSON.parseObject(text, type);
    }

    /**
     * 通知指定的key值,指定class从json串中获取要转换的class
     *
     * @param data
     * @param key
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> T getObjectByKey(String data, String key, Class<T> cls) {
        return getObject(data, JSONObject.class).getObject(key, cls);
    }

    /**
     * java对象转换为字符串
     *
     * @param object
     * @return
     */
    public static String getJsonString(Object object) {
        return JSON.toJSONString(object);
    }

    /**
     * java对象转换为字符串
     *
     * @param object
     * @return
     */
    public static String getJsonString(Object object, SerializerFeature feature) {
        return JSON.toJSONString(object, feature);
    }

    /**
     * java对象转换为JSON
     *
     * @param object
     * @return
     */
    public static JSON getJson(Object object) {
        return (JSON) JSONObject.toJSON(object);
    }

    public static JSON parse(String text){
        return (JSON) JSON.parse(text);
    }

    /**
     * java对象转换为JSON
     *
     * @param collection
     * @return
     */
    public static JSONArray getJsonArray(Collection collection) {
        return (JSONArray) JSON.toJSON(collection);
    }
    /**
     * json串转换为列表对象
     *
     * @param jsonStr
     * @param clazz
     * @return List<T>
     */
    public static <T> List<T> parseArray(String jsonStr, Class<T> clazz) {
        return JSON.parseArray(jsonStr, clazz);
    }

    /**
     * json串转换为列表对象
     *
     * @param jsonStr
     * @return List<T>
     */
    public static JSONArray parseArray(String jsonStr) {
        return JSON.parseArray(jsonStr);
    }


    /**
     * 通知指定的key值,指定class从json串中获取要转换的列表,转换成指定对象列表
     *
     * @param data
     * @param key
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> List<T> getListByKey(String data, String key, Class<T> cls) {
        return getObject(data, JSONObject.class).getJSONArray(key).toJavaList(cls);
    }

    /**
     * 通知指定的key值,指定class从json串中获取要转换的列表,转换成指定对象列表
     *
     * @param data
     * @param key
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> List<T> getListByKey(JSONObject data, String key, Class<T> cls) {
        return data.getJSONArray(key).toJavaList(cls);
    }

    /**
     * json串转换为Map对象
     *
     * @param jsonStr
     * @return
     */
    public static Map<String, Object> json2Map(String jsonStr) {
        return JSON.parseObject(jsonStr, Map.class);
    }

    public static JSONArray listToJsonArray(List list) {
        if (null == list) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(list);
        return jsonArray;
    }
}
