package com.digiwin.athena.cdme.core.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.util.StringUtil;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

/**
 * 参数routerKey校验切面类
 *
 * @author caowlong
 * @date 2021-06-08 11:37
 */
@Aspect
@Component("cdmeRouterKeyAspect")
@EnableAspectJAutoProxy
public class RouterKeyAspect {
    /**
     * 参数routerKey统一校验
     *
     * @param routerKeyAnnotation
     * @return
     */
    @Before("@annotation(routerKeyAnnotation)")
    public void validate(RouterKey routerKeyAnnotation) {
        /** 验证routerKey **/
        String routerKey = (String) DWServiceContext.getContext().getRequestHeader().get(FieldConstant.ROUTER_KEY);
        if (StringUtil.isEmpty(routerKey)) {
            throw new ArgumentValidException(ErrorCodeEnum.ROUTE_KEY_EMPTY);
        }
    }
}