package com.digiwin.athena.cdme.core.config;

import com.digiwin.loadbalance.util.HttpRouteUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * @description: 侦测对外接口
 * @author: dongwh
 * @date: 2021/4/12 15:03
 */
@Configuration
public class CdmeRestTemplateConfig {
    @Value("${cdme.httpClientMaxTotal}")
    private int maxTotal;
    @Value("${cdme.httpClientMaxPerRoute}")
    private int maxPerRoute;
    @Value("${cdme.httpClientRequestTimeOutMilliSecond}")
    private int requestTimeOutMilliSecond;
    @Value("${cdme.httpClientConnectTimeOutMilliSecond}")
    private int connectTimeOutMilliSecond;
    @Value("${cdme.httpClientSocketTimeOutMilliSecond}")
    private int socketTimeOutMilliSecond;

    @Autowired(required = false)
    @Qualifier(HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN)
    HttpRoutePlanner httpRoutePlanner;

    @Bean("cdmeRestTemplate")
    public RestTemplate cdmeRestTemplate() {
        return new RestTemplate(httpRequestFactory());
    }

    private ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(httpClient());
    }

    private HttpClient httpClient() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        /** 设置整个连接池最大连接数 */
        connectionManager.setMaxTotal(maxTotal);

        /** 路由是对maxTotal的细分 */
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom()
                /** 返回数据的超时时间 */
                .setSocketTimeout(socketTimeOutMilliSecond)
                /** 连接上服务器的超时时间 */
                .setConnectTimeout(connectTimeOutMilliSecond)
                /** 从连接池中获取连接的超时时间 */
                .setConnectionRequestTimeout(requestTimeOutMilliSecond)
                .build();
        return HttpClientBuilder.create()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(connectionManager)
                .setRoutePlanner(httpRoutePlanner)
                .build();
    }
}
