package com.digiwin.athena.cdme.core.enums;

/**
 * @description: 运维接口返回信息
 * @author: renwm
 * @date: 2020/5/9 9:09
 */
public enum MonitorOpsEnum {

    /** 侦测规则状态：是否可用 */
    ISENABLE_Y("Y", "可用"),
    ISENABLE_N("N", "不可用"),
    /** 排程实例状态,1.未同步排程 2:排程创建成功 3:创建排程失败*/
    STATUS_UNSYNCHRONIZED("1", "未同步排程"),
    STATUS_CREATE_SUCCESS("2", "排程创建成功"),
    STATUS_CREATE_FAIL("3", "创建排程失败"),
    /** 排程实例启停状态 **/
    SCHEDULE_ISENABLE_Y("YES", "启用"),
    SCHEDULE_ISENABLE_N("NO", "停用");

    private final String type;
    private final String desc;

    MonitorOpsEnum(String type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    public static String getEnumByType(String type) {
        for (MonitorOpsEnum itemEnum : MonitorOpsEnum.values()) {
            if (itemEnum.getType().equals(type)) {
                return itemEnum.getDesc();
            }
        }
        return "";
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
