package com.digiwin.athena.cdme.core.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;

/**
 * @description: 适用于模组中的业务异常场景。例如：解析参数错误，调用sdk返回结果异常，解析元数据失败，通过逻辑判断后不符合预期的异常场景。
 * @author: dongwh
 * @date: 2022/1/6 14:54
 */
public class BusinessException extends DWRuntimeException implements UnRetryable {

    /**
     * 构造一个基本异常.
     * @param errorCodeEnum 错误码枚举
     */
    public BusinessException(ErrorCodeEnum errorCodeEnum) {
        super(errorCodeEnum.getCode(), errorCodeEnum.getMessage());
    }

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public BusinessException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     * @param message 错误码
     * @param message 信息描述
     */
    public BusinessException(String errorCode, String message) {
        super(errorCode, message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }
}
